/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@Deprecated
public class Counter {
    private static final int MAX_CELLS_LENGTH = 0x100000;
    private final AtomicReference<Container> containerRef;

    public Counter() {
        this(new Cell());
    }

    public Counter(long initValue) {
        this(new Cell(initValue));
    }

    private Counter(Cell initCell) {
        this.containerRef = new AtomicReference<Container>(new Container(initCell));
    }

    private static int hash() {
        int h = System.identityHashCode(Thread.currentThread());
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h;
    }

    public void add(long delta) {
        Container container = this.containerRef.get();
        Cell[] cells = container.cells;
        int mask = cells.length - 1;
        int baseIndex = Counter.hash();
        if (cells[baseIndex & mask].add(delta)) {
            return;
        }
        int index2 = baseIndex + 1;
        while (!cells[index2 & mask].add(delta)) {
            ++index2;
        }
        if (index2 - baseIndex >= cells.length && cells.length < 0x100000 && container.demoted.compareAndSet(false, true) && this.containerRef.get() == container) {
            Cell[] newCells = new Cell[cells.length * 2];
            System.arraycopy(cells, 0, newCells, 0, cells.length);
            for (int i2 = cells.length; i2 < newCells.length; ++i2) {
                newCells[i2] = new Cell();
            }
            this.containerRef.compareAndSet(container, new Container(newCells));
        }
    }

    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    public void set(long value2) {
        this.containerRef.set(new Container(new Cell(value2)));
    }

    public long get() {
        long sum2 = 0L;
        for (Cell cell : this.containerRef.get().cells) {
            sum2 += cell.get();
        }
        return sum2;
    }

    public String toString() {
        Cell[] cells = this.containerRef.get().cells;
        long min2 = Long.MAX_VALUE;
        long max2 = Long.MIN_VALUE;
        long sum2 = 0L;
        for (Cell cell : cells) {
            long value2 = cell.get();
            sum2 += value2;
            if (min2 > value2) {
                min2 = value2;
            }
            if (max2 >= value2) continue;
            max2 = value2;
        }
        return new StringBuilder(100).append("[value=").append(sum2).append(", cells=[length=").append(cells.length).append(", min=").append(min2).append(", max=").append(max2).append("]]").toString();
    }

    private static class Container {
        final Cell[] cells;
        final AtomicBoolean demoted = new AtomicBoolean();

        Container(Cell cell) {
            this(new Cell[]{cell});
        }

        Container(Cell[] cells) {
            this.cells = cells;
        }
    }

    private static class Cell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;
        static final AtomicLongFieldUpdater<Cell> valueUpdater = AtomicLongFieldUpdater.newUpdater(Cell.class, "value");

        Cell() {
        }

        Cell(long initValue) {
            this.value = initValue;
        }

        long get() {
            return this.value;
        }

        boolean add(long delta) {
            long current2 = this.value;
            return valueUpdater.compareAndSet(this, current2, current2 + delta);
        }
    }
}

