/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.protobuf.ByteString;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.UnsafeAccess;
import org.apache.hadoop.hbase.util.UnsafeAvailChecker;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

@InterfaceAudience.Public
@SuppressWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="It has been like this forever")
public class Bytes
implements Comparable<Bytes> {
    private static final String UTF8_CSN = StandardCharsets.UTF_8.name();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger LOG = LoggerFactory.getLogger(Bytes.class);
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;
    public static final long MASK_FOR_LOWER_INT_IN_LONG = -4294967296L;
    public static final int ESTIMATED_HEAP_TAX = 16;
    @InterfaceAudience.Private
    static final boolean UNSAFE_UNALIGNED = UnsafeAvailChecker.unaligned();
    private byte[] bytes;
    private int offset;
    private int length;
    public static final Comparator<byte[]> BYTES_COMPARATOR = new ByteArrayComparator();
    public static final RawComparator<byte[]> BYTES_RAWCOMPARATOR = new ByteArrayComparator();
    private static final char[] HEX_CHARS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Random RNG = new Random();
    private static final SecureRandom SECURE_RNG = new SecureRandom();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final int len(byte[] b) {
        return b == null ? 0 : b.length;
    }

    public Bytes() {
    }

    public Bytes(byte[] bytes2) {
        this(bytes2, 0, bytes2.length);
    }

    public Bytes(Bytes ibw) {
        this(ibw.get(), ibw.getOffset(), ibw.getLength());
    }

    public Bytes(byte[] bytes2, int offset2, int length2) {
        this.bytes = bytes2;
        this.offset = offset2;
        this.length = length2;
    }

    @Deprecated
    public Bytes(ByteString byteString) {
        this(byteString.toByteArray());
    }

    public byte[] get() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.bytes;
    }

    public void set(byte[] b) {
        this.set(b, 0, b.length);
    }

    public void set(byte[] b, int offset2, int length2) {
        this.bytes = b;
        this.offset = offset2;
        this.length = length2;
    }

    @Deprecated
    public int getSize() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.length;
    }

    public int getLength() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    @Deprecated
    public ByteString toByteString() {
        return ByteString.copyFrom(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        return Bytes.hashCode(this.bytes, this.offset, this.length);
    }

    @Override
    public int compareTo(Bytes that) {
        return BYTES_RAWCOMPARATOR.compare(this.bytes, this.offset, this.length, that.bytes, that.offset, that.length);
    }

    @Override
    public int compareTo(byte[] that) {
        return BYTES_RAWCOMPARATOR.compare(this.bytes, this.offset, this.length, that, 0, that.length);
    }

    public boolean equals(Object right_obj) {
        if (right_obj instanceof byte[]) {
            return this.compareTo((byte[])right_obj) == 0;
        }
        if (right_obj instanceof Bytes) {
            return this.compareTo((Bytes)right_obj) == 0;
        }
        return false;
    }

    public String toString() {
        return Bytes.toString(this.bytes, this.offset, this.length);
    }

    public static byte[][] toArray(List<byte[]> array) {
        byte[][] results = new byte[array.size()][];
        for (int i2 = 0; i2 < array.size(); ++i2) {
            results[i2] = array.get(i2);
        }
        return results;
    }

    public byte[] copyBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        if (len < 0) {
            throw new NegativeArraySizeException(Integer.toString(len));
        }
        byte[] result2 = new byte[len];
        in.readFully(result2, 0, len);
        return result2;
    }

    public static byte[] readByteArrayThrowsRuntime(DataInput in) {
        try {
            return Bytes.readByteArray(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] b) throws IOException {
        if (b == null) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
        } else {
            Bytes.writeByteArray(out, b, 0, b.length);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] b, int offset2, int length2) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)length2);
        out.write(b, offset2, length2);
    }

    public static int writeByteArray(byte[] tgt, int tgtOffset, byte[] src, int srcOffset, int srcLength) {
        byte[] vint = Bytes.vintToBytes(srcLength);
        System.arraycopy(vint, 0, tgt, tgtOffset, vint.length);
        int offset2 = tgtOffset + vint.length;
        System.arraycopy(src, srcOffset, tgt, offset2, srcLength);
        return offset2 + srcLength;
    }

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putByte(byte[] bytes2, int offset2, byte b) {
        bytes2[offset2] = b;
        return offset2 + 1;
    }

    public static int putByteBuffer(byte[] bytes2, int offset2, ByteBuffer buf) {
        int len = buf.remaining();
        buf.get(bytes2, offset2, len);
        return offset2 + len;
    }

    public static byte[] toBytes(ByteBuffer buf) {
        ByteBuffer dup2 = buf.duplicate();
        dup2.position(0);
        return Bytes.readBytes(dup2);
    }

    private static byte[] readBytes(ByteBuffer buf) {
        byte[] result2 = new byte[buf.remaining()];
        buf.get(result2);
        return result2;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return Bytes.toString(b, 0, b.length);
    }

    public static String toString(byte[] b1, String sep, byte[] b2) {
        return Bytes.toString(b1, 0, b1.length) + sep + Bytes.toString(b2, 0, b2.length);
    }

    public static String toString(byte[] b, int off) {
        if (b == null) {
            return null;
        }
        int len = b.length - off;
        if (len <= 0) {
            return "";
        }
        try {
            return new String(b, off, len, UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        try {
            return new String(b, off, len, UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    public static String toStringBinary(byte[] b) {
        if (b == null) {
            return "null";
        }
        return Bytes.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(ByteBuffer buf) {
        if (buf == null) {
            return "null";
        }
        if (buf.hasArray()) {
            return Bytes.toStringBinary(buf.array(), buf.arrayOffset(), buf.limit());
        }
        return Bytes.toStringBinary(Bytes.toBytes(buf));
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result2 = new StringBuilder();
        if (off >= b.length) {
            return result2.toString();
        }
        if (off + len > b.length) {
            len = b.length - off;
        }
        for (int i2 = off; i2 < off + len; ++i2) {
            int ch = b[i2] & 0xFF;
            if (ch >= 32 && ch <= 126 && ch != 92) {
                result2.append((char)ch);
                continue;
            }
            result2.append("\\x");
            result2.append(HEX_CHARS_UPPER[ch / 16]);
            result2.append(HEX_CHARS_UPPER[ch % 16]);
        }
        return result2.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static byte toBinaryFromHex(byte ch) {
        if (ch >= 65 && ch <= 70) {
            return (byte)(10 + (byte)(ch - 65));
        }
        return (byte)(ch - 48);
    }

    public static byte[] toBytesBinary(String in) {
        byte[] b = new byte[in.length()];
        int size2 = 0;
        for (int i2 = 0; i2 < in.length(); ++i2) {
            char ch = in.charAt(i2);
            if (ch == '\\' && in.length() > i2 + 1 && in.charAt(i2 + 1) == 'x') {
                char hd1 = in.charAt(i2 + 2);
                char hd2 = in.charAt(i2 + 3);
                if (!Bytes.isHexDigit(hd1) || !Bytes.isHexDigit(hd2)) continue;
                byte d = (byte)((Bytes.toBinaryFromHex((byte)hd1) << 4) + Bytes.toBinaryFromHex((byte)hd2));
                b[size2++] = d;
                i2 += 3;
                continue;
            }
            b[size2++] = (byte)ch;
        }
        byte[] b2 = new byte[size2];
        System.arraycopy(b, 0, b2, 0, size2);
        return b2;
    }

    public static byte[] toBytes(String s2) {
        try {
            return s2.getBytes(UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 decoding is not supported", e);
        }
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array has wrong size: " + b.length);
        }
        return b[0] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i2 = 7; i2 > 0; --i2) {
            b[i2] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes2) {
        return Bytes.toLong(bytes2, 0, 8);
    }

    public static long toLong(byte[] bytes2, int offset2) {
        return Bytes.toLong(bytes2, offset2, 8);
    }

    public static long toLong(byte[] bytes2, int offset2, int length2) {
        if (length2 != 8 || offset2 + length2 > bytes2.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes2, offset2, length2, 8);
        }
        return ConverterHolder.BEST_CONVERTER.toLong(bytes2, offset2, length2);
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes2, int offset2, int length2, int expectedLength) {
        String reason2 = length2 != expectedLength ? "Wrong length: " + length2 + ", expected " + expectedLength : "offset (" + offset2 + ") + length (" + length2 + ") exceed the capacity of the array: " + bytes2.length;
        return new IllegalArgumentException(reason2);
    }

    public static int putLong(byte[] bytes2, int offset2, long val) {
        if (bytes2.length - offset2 < 8) {
            throw new IllegalArgumentException("Not enough room to put a long at offset " + offset2 + " in a " + bytes2.length + " byte array");
        }
        return ConverterHolder.BEST_CONVERTER.putLong(bytes2, offset2, val);
    }

    @Deprecated
    public static int putLongUnsafe(byte[] bytes2, int offset2, long val) {
        return UnsafeAccess.putLong(bytes2, offset2, val);
    }

    public static float toFloat(byte[] bytes2) {
        return Bytes.toFloat(bytes2, 0);
    }

    public static float toFloat(byte[] bytes2, int offset2) {
        return Float.intBitsToFloat(Bytes.toInt(bytes2, offset2, 4));
    }

    public static int putFloat(byte[] bytes2, int offset2, float f) {
        return Bytes.putInt(bytes2, offset2, Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToRawIntBits(f));
    }

    public static double toDouble(byte[] bytes2) {
        return Bytes.toDouble(bytes2, 0);
    }

    public static double toDouble(byte[] bytes2, int offset2) {
        return Double.longBitsToDouble(Bytes.toLong(bytes2, offset2, 8));
    }

    public static int putDouble(byte[] bytes2, int offset2, double d) {
        return Bytes.putLong(bytes2, offset2, Double.doubleToLongBits(d));
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i2 = 3; i2 > 0; --i2) {
            b[i2] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int toInt(byte[] bytes2) {
        return Bytes.toInt(bytes2, 0, 4);
    }

    public static int toInt(byte[] bytes2, int offset2) {
        return Bytes.toInt(bytes2, offset2, 4);
    }

    public static int toInt(byte[] bytes2, int offset2, int length2) {
        if (length2 != 4 || offset2 + length2 > bytes2.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes2, offset2, length2, 4);
        }
        return ConverterHolder.BEST_CONVERTER.toInt(bytes2, offset2, length2);
    }

    @Deprecated
    public static int toIntUnsafe(byte[] bytes2, int offset2) {
        return UnsafeAccess.toInt(bytes2, offset2);
    }

    @Deprecated
    public static short toShortUnsafe(byte[] bytes2, int offset2) {
        return UnsafeAccess.toShort(bytes2, offset2);
    }

    @Deprecated
    public static long toLongUnsafe(byte[] bytes2, int offset2) {
        return UnsafeAccess.toLong(bytes2, offset2);
    }

    public static int readAsInt(byte[] bytes2, int offset2, int length2) {
        if (offset2 + length2 > bytes2.length) {
            throw new IllegalArgumentException("offset (" + offset2 + ") + length (" + length2 + ") exceed the capacity of the array: " + bytes2.length);
        }
        int n = 0;
        for (int i2 = offset2; i2 < offset2 + length2; ++i2) {
            n <<= 8;
            n ^= bytes2[i2] & 0xFF;
        }
        return n;
    }

    public static int putInt(byte[] bytes2, int offset2, int val) {
        if (bytes2.length - offset2 < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset2 + " in a " + bytes2.length + " byte array");
        }
        return ConverterHolder.BEST_CONVERTER.putInt(bytes2, offset2, val);
    }

    @Deprecated
    public static int putIntUnsafe(byte[] bytes2, int offset2, int val) {
        return UnsafeAccess.putInt(bytes2, offset2, val);
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes2) {
        return Bytes.toShort(bytes2, 0, 2);
    }

    public static short toShort(byte[] bytes2, int offset2) {
        return Bytes.toShort(bytes2, offset2, 2);
    }

    public static short toShort(byte[] bytes2, int offset2, int length2) {
        if (length2 != 2 || offset2 + length2 > bytes2.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes2, offset2, length2, 2);
        }
        return ConverterHolder.BEST_CONVERTER.toShort(bytes2, offset2, length2);
    }

    public static byte[] getBytes(ByteBuffer buf) {
        return Bytes.readBytes(buf.duplicate());
    }

    public static int putShort(byte[] bytes2, int offset2, short val) {
        if (bytes2.length - offset2 < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset2 + " in a " + bytes2.length + " byte array");
        }
        return ConverterHolder.BEST_CONVERTER.putShort(bytes2, offset2, val);
    }

    @Deprecated
    public static int putShortUnsafe(byte[] bytes2, int offset2, short val) {
        return UnsafeAccess.putShort(bytes2, offset2, val);
    }

    public static int putAsShort(byte[] bytes2, int offset2, int val) {
        if (bytes2.length - offset2 < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset2 + " in a " + bytes2.length + " byte array");
        }
        bytes2[offset2 + 1] = (byte)val;
        bytes2[offset2] = (byte)(val >>= 8);
        return offset2 + 2;
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result2 = new byte[valueBytes.length + 4];
        int offset2 = Bytes.putInt(result2, 0, val.scale());
        Bytes.putBytes(result2, offset2, valueBytes, 0, valueBytes.length);
        return result2;
    }

    public static BigDecimal toBigDecimal(byte[] bytes2) {
        return Bytes.toBigDecimal(bytes2, 0, bytes2.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes2, int offset2, int length2) {
        if (bytes2 == null || length2 < 5 || offset2 + length2 > bytes2.length) {
            return null;
        }
        int scale = Bytes.toInt(bytes2, offset2);
        byte[] tcBytes = new byte[length2 - 4];
        System.arraycopy(bytes2, offset2 + 4, tcBytes, 0, length2 - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int putBigDecimal(byte[] bytes2, int offset2, BigDecimal val) {
        if (bytes2 == null) {
            return offset2;
        }
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result2 = new byte[valueBytes.length + 4];
        offset2 = Bytes.putInt(result2, offset2, val.scale());
        return Bytes.putBytes(result2, offset2, valueBytes, 0, valueBytes.length);
    }

    public static byte[] vintToBytes(long vint) {
        long i2 = vint;
        int size2 = WritableUtils.getVIntSize((long)i2);
        byte[] result2 = new byte[size2];
        int offset2 = 0;
        if (i2 >= -112L && i2 <= 127L) {
            result2[offset2] = (byte)i2;
            return result2;
        }
        int len = -112;
        if (i2 < 0L) {
            i2 ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i2;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        result2[offset2++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result2[offset2++] = (byte)((i2 & mask) >> shiftbits);
        }
        return result2;
    }

    public static long bytesToVint(byte[] buffer) {
        byte firstByte;
        int len;
        int offset2 = 0;
        if ((len = WritableUtils.decodeVIntSize((byte)(firstByte = buffer[offset2++]))) == 1) {
            return firstByte;
        }
        long i2 = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset2++];
            i2 <<= 8;
            i2 |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i2 ^ 0xFFFFFFFFFFFFFFFFL : i2;
    }

    @Deprecated
    public static long readVLong(byte[] buffer, int offset2) throws IOException {
        return Bytes.readAsVLong(buffer, offset2);
    }

    public static long readAsVLong(byte[] buffer, int offset2) {
        byte firstByte = buffer[offset2];
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i2 = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset2 + 1 + idx];
            i2 <<= 8;
            i2 |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i2 ^ 0xFFFFFFFFFFFFFFFFL : i2;
    }

    public static int compareTo(byte[] left, byte[] right) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(left, 0, left == null ? 0 : left.length, right, 0, right == null ? 0 : right.length);
    }

    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(buffer1, offset1, length1, buffer2, offset2, length2);
    }

    @InterfaceAudience.Private
    static Comparer<byte[]> lexicographicalComparerJavaImpl() {
        return LexicographicalComparerHolder.PureJavaComparer.INSTANCE;
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        if (left.length == 0) {
            return true;
        }
        if (left[left.length - 1] != right[right.length - 1]) {
            return false;
        }
        return Bytes.compareTo(left, right) == 0;
    }

    public static boolean equals(byte[] left, int leftOffset, int leftLen, byte[] right, int rightOffset, int rightLen) {
        if (left == right && leftOffset == rightOffset && leftLen == rightLen) {
            return true;
        }
        if (leftLen != rightLen) {
            return false;
        }
        if (leftLen == 0) {
            return true;
        }
        if (left[leftOffset + leftLen - 1] != right[rightOffset + rightLen - 1]) {
            return false;
        }
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(left, leftOffset, leftLen, right, rightOffset, rightLen) == 0;
    }

    public static boolean equals(byte[] a, ByteBuffer buf) {
        if (a == null) {
            return buf == null;
        }
        if (buf == null) {
            return false;
        }
        if (a.length != buf.remaining()) {
            return false;
        }
        ByteBuffer b = buf.duplicate();
        for (byte anA : a) {
            if (anA == b.get()) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(byte[] bytes2, byte[] prefix) {
        return bytes2 != null && prefix != null && bytes2.length >= prefix.length && LexicographicalComparerHolder.BEST_COMPARER.compareTo(bytes2, 0, prefix.length, prefix, 0, prefix.length) == 0;
    }

    public static int hashCode(byte[] b) {
        return Bytes.hashCode(b, b.length);
    }

    public static int hashCode(byte[] b, int length2) {
        return WritableComparator.hashBytes((byte[])b, (int)length2);
    }

    public static Integer mapKey(byte[] b) {
        return Bytes.hashCode(b);
    }

    public static Integer mapKey(byte[] b, int length2) {
        return Bytes.hashCode(b, length2);
    }

    public static byte[] add(byte[] a, byte[] b) {
        return Bytes.add(a, b, EMPTY_BYTE_ARRAY);
    }

    public static byte[] add(byte[] a, byte[] b, byte[] c) {
        byte[] result2 = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, result2, 0, a.length);
        System.arraycopy(b, 0, result2, a.length, b.length);
        System.arraycopy(c, 0, result2, a.length + b.length, c.length);
        return result2;
    }

    public static byte[] add(byte[][] arrays) {
        int length2 = 0;
        for (int i2 = 0; i2 < arrays.length; ++i2) {
            length2 += arrays[i2].length;
        }
        byte[] result2 = new byte[length2];
        int index2 = 0;
        for (int i3 = 0; i3 < arrays.length; ++i3) {
            System.arraycopy(arrays[i3], 0, result2, index2, arrays[i3].length);
            index2 += arrays[i3].length;
        }
        return result2;
    }

    public static byte[] head(byte[] a, int length2) {
        if (a.length < length2) {
            return null;
        }
        byte[] result2 = new byte[length2];
        System.arraycopy(a, 0, result2, 0, length2);
        return result2;
    }

    public static byte[] tail(byte[] a, int length2) {
        if (a.length < length2) {
            return null;
        }
        byte[] result2 = new byte[length2];
        System.arraycopy(a, a.length - length2, result2, 0, length2);
        return result2;
    }

    public static byte[] padHead(byte[] a, int length2) {
        byte[] padding = new byte[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            padding[i2] = 0;
        }
        return Bytes.add(padding, a);
    }

    public static byte[] padTail(byte[] a, int length2) {
        byte[] padding = new byte[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            padding[i2] = 0;
        }
        return Bytes.add(a, padding);
    }

    public static byte[][] split(byte[] a, byte[] b, int num) {
        return Bytes.split(a, b, false, num);
    }

    public static byte[][] split(byte[] a, byte[] b, boolean inclusive, int num) {
        byte[][] ret = new byte[num + 2][];
        int i2 = 0;
        Iterable<byte[]> iter = Bytes.iterateOnSplits(a, b, inclusive, num);
        if (iter == null) {
            return null;
        }
        for (byte[] elem : iter) {
            ret[i2++] = elem;
        }
        return ret;
    }

    public static Iterable<byte[]> iterateOnSplits(byte[] a, byte[] b, int num) {
        return Bytes.iterateOnSplits(a, b, false, num);
    }

    public static Iterable<byte[]> iterateOnSplits(final byte[] a, final byte[] b, boolean inclusive, final int num) {
        BigInteger intervalBI;
        BigInteger splitsBI;
        byte[] bPadded;
        byte[] aPadded;
        if (a.length < b.length) {
            aPadded = Bytes.padTail(a, b.length - a.length);
            bPadded = b;
        } else if (b.length < a.length) {
            aPadded = a;
            bPadded = Bytes.padTail(b, a.length - b.length);
        } else {
            aPadded = a;
            bPadded = b;
        }
        if (Bytes.compareTo(aPadded, bPadded) >= 0) {
            throw new IllegalArgumentException("b <= a");
        }
        if (num <= 0) {
            throw new IllegalArgumentException("num cannot be <= 0");
        }
        byte[] prependHeader = new byte[]{1, 0};
        final BigInteger startBI = new BigInteger(Bytes.add(prependHeader, aPadded));
        BigInteger stopBI = new BigInteger(Bytes.add(prependHeader, bPadded));
        BigInteger diffBI = stopBI.subtract(startBI);
        if (inclusive) {
            diffBI = diffBI.add(BigInteger.ONE);
        }
        if (diffBI.compareTo(splitsBI = BigInteger.valueOf(num + 1)) < 0) {
            byte[] aPaddedAdditional = new byte[aPadded.length + 1];
            byte[] bPaddedAdditional = new byte[bPadded.length + 1];
            for (int i2 = 0; i2 < aPadded.length; ++i2) {
                aPaddedAdditional[i2] = aPadded[i2];
            }
            for (int j = 0; j < bPadded.length; ++j) {
                bPaddedAdditional[j] = bPadded[j];
            }
            aPaddedAdditional[aPadded.length] = 0;
            bPaddedAdditional[bPadded.length] = 0;
            return Bytes.iterateOnSplits(aPaddedAdditional, bPaddedAdditional, inclusive, num);
        }
        try {
            intervalBI = diffBI.divide(splitsBI);
        }
        catch (Exception e) {
            LOG.error("Exception caught during division", e);
            return null;
        }
        final Iterator<byte[]> iterator = new Iterator<byte[]>(){
            private int i = -1;

            @Override
            public boolean hasNext() {
                return this.i < num + 1;
            }

            @Override
            public byte[] next() {
                ++this.i;
                if (this.i == 0) {
                    return a;
                }
                if (this.i == num + 1) {
                    return b;
                }
                BigInteger curBI = startBI.add(intervalBI.multiply(BigInteger.valueOf(this.i)));
                byte[] padded = curBI.toByteArray();
                padded = padded[1] == 0 ? Bytes.tail(padded, padded.length - 2) : Bytes.tail(padded, padded.length - 1);
                return padded;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<byte[]>(){

            @Override
            public Iterator<byte[]> iterator() {
                return iterator;
            }
        };
    }

    public static int hashCode(byte[] bytes2, int offset2, int length2) {
        int hash2 = 1;
        for (int i2 = offset2; i2 < offset2 + length2; ++i2) {
            hash2 = 31 * hash2 + bytes2[i2];
        }
        return hash2;
    }

    public static byte[][] toByteArrays(String[] t) {
        byte[][] result2 = new byte[t.length][];
        for (int i2 = 0; i2 < t.length; ++i2) {
            result2[i2] = Bytes.toBytes(t[i2]);
        }
        return result2;
    }

    public static byte[][] toBinaryByteArrays(String[] t) {
        byte[][] result2 = new byte[t.length][];
        for (int i2 = 0; i2 < t.length; ++i2) {
            result2[i2] = Bytes.toBytesBinary(t[i2]);
        }
        return result2;
    }

    public static byte[][] toByteArrays(String column) {
        return Bytes.toByteArrays(Bytes.toBytes(column));
    }

    public static byte[][] toByteArrays(byte[] column) {
        byte[][] result2 = new byte[][]{column};
        return result2;
    }

    @Deprecated
    public static int binarySearch(byte[][] arr, byte[] key2, int offset2, int length2, RawComparator<?> comparator) {
        return Bytes.binarySearch(arr, key2, offset2, length2);
    }

    public static int binarySearch(byte[][] arr, byte[] key2, int offset2, int length2) {
        int low = 0;
        int high = arr.length - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            int cmp2 = BYTES_RAWCOMPARATOR.compare(key2, offset2, length2, arr[mid], 0, arr[mid].length);
            if (cmp2 > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp2 < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Deprecated
    public static int binarySearch(byte[][] arr, Cell key2, RawComparator<Cell> comparator) {
        int low = 0;
        int high = arr.length - 1;
        KeyValue.KeyOnlyKeyValue r = new KeyValue.KeyOnlyKeyValue();
        while (low <= high) {
            int mid = low + (high - low >> 1);
            r.setKey(arr[mid], 0, arr[mid].length);
            int cmp2 = comparator.compare((Object)key2, (Object)r);
            if (cmp2 > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp2 < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(Cell[] arr, Cell key2, CellComparator comparator) {
        int low = 0;
        int high = arr.length - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            int cmp2 = comparator.compare(key2, arr[mid]);
            if (cmp2 > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp2 < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static byte[] incrementBytes(byte[] value2, long amount) {
        byte[] val = value2;
        if (val.length < 8) {
            byte[] newvalue = val[0] < 0 ? new byte[]{-1, -1, -1, -1, -1, -1, -1, -1} : new byte[8];
            System.arraycopy(val, 0, newvalue, newvalue.length - val.length, val.length);
            val = newvalue;
        } else if (val.length > 8) {
            throw new IllegalArgumentException("Increment Bytes - value too big: " + val.length);
        }
        if (amount == 0L) {
            return val;
        }
        if (val[0] < 0) {
            return Bytes.binaryIncrementNeg(val, amount);
        }
        return Bytes.binaryIncrementPos(val, amount);
    }

    private static byte[] binaryIncrementPos(byte[] value2, long amount) {
        long amo = amount;
        int sign2 = 1;
        if (amount < 0L) {
            amo = -amount;
            sign2 = -1;
        }
        for (int i2 = 0; i2 < value2.length; ++i2) {
            int cur = (int)amo % 256 * sign2;
            amo >>= 8;
            int val = value2[value2.length - i2 - 1] & 0xFF;
            int total2 = val + cur;
            if (total2 > 255) {
                amo += (long)sign2;
                total2 %= 256;
            } else if (total2 < 0) {
                amo -= (long)sign2;
            }
            value2[value2.length - i2 - 1] = (byte)total2;
            if (amo != 0L) continue;
            return value2;
        }
        return value2;
    }

    private static byte[] binaryIncrementNeg(byte[] value2, long amount) {
        long amo = amount;
        int sign2 = 1;
        if (amount < 0L) {
            amo = -amount;
            sign2 = -1;
        }
        for (int i2 = 0; i2 < value2.length; ++i2) {
            int cur = (int)amo % 256 * sign2;
            amo >>= 8;
            int val = (~value2[value2.length - i2 - 1] & 0xFF) + 1;
            int total2 = cur - val;
            if (total2 >= 0) {
                amo += (long)sign2;
            } else if (total2 < -256) {
                amo -= (long)sign2;
                total2 %= 256;
            }
            value2[value2.length - i2 - 1] = (byte)total2;
            if (amo != 0L) continue;
            return value2;
        }
        return value2;
    }

    public static void writeStringFixedSize(DataOutput out, String s2, int size2) throws IOException {
        byte[] b = Bytes.toBytes(s2);
        if (b.length > size2) {
            throw new IOException("Trying to write " + b.length + " bytes (" + Bytes.toStringBinary(b) + ") into a field of length " + size2);
        }
        out.writeBytes(s2);
        for (int i2 = 0; i2 < size2 - s2.length(); ++i2) {
            out.writeByte(0);
        }
    }

    public static String readStringFixedSize(DataInput in, int size2) throws IOException {
        int n;
        byte[] b = new byte[size2];
        in.readFully(b);
        for (n = b.length; n > 0 && b[n - 1] == 0; --n) {
        }
        return Bytes.toString(b, 0, n);
    }

    public static byte[] copy(byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        byte[] result2 = new byte[bytes2.length];
        System.arraycopy(bytes2, 0, result2, 0, bytes2.length);
        return result2;
    }

    public static byte[] copy(byte[] bytes2, int offset2, int length2) {
        if (bytes2 == null) {
            return null;
        }
        byte[] result2 = new byte[length2];
        System.arraycopy(bytes2, offset2, result2, 0, length2);
        return result2;
    }

    public static int unsignedBinarySearch(byte[] a, int fromIndex, int toIndex, byte key2) {
        int unsignedKey = key2 & 0xFF;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            int midVal = a[mid] & 0xFF;
            if (midVal < unsignedKey) {
                low = mid + 1;
                continue;
            }
            if (midVal > unsignedKey) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static byte[] unsignedCopyAndIncrement(byte[] input) {
        byte[] copy = Bytes.copy(input);
        if (copy == null) {
            throw new IllegalArgumentException("cannot increment null array");
        }
        for (int i2 = copy.length - 1; i2 >= 0; --i2) {
            if (copy[i2] != -1) {
                int n = i2;
                copy[n] = (byte)(copy[n] + 1);
                return copy;
            }
            copy[i2] = 0;
        }
        byte[] out = new byte[copy.length + 1];
        out[0] = 1;
        System.arraycopy(copy, 0, out, 1, copy.length);
        return out;
    }

    public static boolean equals(List<byte[]> a, List<byte[]> b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i2 = 0; i2 < a.size(); ++i2) {
            if (Bytes.equals(a.get(i2), b.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(Collection<byte[]> arrays) {
        if (!CollectionUtils.isEmpty(arrays)) {
            byte[] previous = new byte[]{};
            for (byte[] array : arrays) {
                if (Bytes.compareTo(previous, array) > 0) {
                    return false;
                }
                previous = array;
            }
        }
        return true;
    }

    public static List<byte[]> getUtf8ByteArrays(List<String> strings) {
        if (CollectionUtils.isEmpty(strings)) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>(strings.size());
        strings.forEach(s2 -> byteArrays.add(Bytes.toBytes(s2)));
        return byteArrays;
    }

    public static int indexOf(byte[] array, byte target) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array.length - target.length + 1; ++i2) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i2 + j] != target[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte target) {
        return Bytes.indexOf(array, target) > -1;
    }

    public static boolean contains(byte[] array, byte[] target) {
        return Bytes.indexOf(array, target) > -1;
    }

    public static void zero(byte[] b) {
        Bytes.zero(b, 0, b.length);
    }

    public static void zero(byte[] b, int offset2, int length2) {
        Preconditions.checkPositionIndex(offset2, b.length, "offset");
        Preconditions.checkArgument(length2 > 0, "length must be greater than 0");
        Preconditions.checkPositionIndex(offset2 + length2, b.length, "offset + length");
        Arrays.fill(b, offset2, offset2 + length2, (byte)0);
    }

    public static void random(byte[] b) {
        RNG.nextBytes(b);
    }

    public static void random(byte[] b, int offset2, int length2) {
        Preconditions.checkPositionIndex(offset2, b.length, "offset");
        Preconditions.checkArgument(length2 > 0, "length must be greater than 0");
        Preconditions.checkPositionIndex(offset2 + length2, b.length, "offset + length");
        byte[] buf = new byte[length2];
        RNG.nextBytes(buf);
        System.arraycopy(buf, 0, b, offset2, length2);
    }

    public static void secureRandom(byte[] b) {
        SECURE_RNG.nextBytes(b);
    }

    public static void secureRandom(byte[] b, int offset2, int length2) {
        Preconditions.checkPositionIndex(offset2, b.length, "offset");
        Preconditions.checkArgument(length2 > 0, "length must be greater than 0");
        Preconditions.checkPositionIndex(offset2 + length2, b.length, "offset + length");
        byte[] buf = new byte[length2];
        SECURE_RNG.nextBytes(buf);
        System.arraycopy(buf, 0, b, offset2, length2);
    }

    public static byte[] createMaxByteArray(int maxByteCount) {
        byte[] maxByteArray = new byte[maxByteCount];
        for (int i2 = 0; i2 < maxByteArray.length; ++i2) {
            maxByteArray[i2] = -1;
        }
        return maxByteArray;
    }

    public static byte[] multiple(byte[] srcBytes, int multiNum) {
        if (multiNum <= 0) {
            return new byte[0];
        }
        byte[] result2 = new byte[srcBytes.length * multiNum];
        for (int i2 = 0; i2 < multiNum; ++i2) {
            System.arraycopy(srcBytes, 0, result2, i2 * srcBytes.length, srcBytes.length);
        }
        return result2;
    }

    public static String toHex(byte[] b, int offset2, int length2) {
        Preconditions.checkArgument(length2 <= 0x3FFFFFFF);
        int numChars = length2 * 2;
        char[] ch = new char[numChars];
        for (int i2 = 0; i2 < numChars; i2 += 2) {
            byte d = b[offset2 + i2 / 2];
            ch[i2] = HEX_CHARS[d >> 4 & 0xF];
            ch[i2 + 1] = HEX_CHARS[d & 0xF];
        }
        return new String(ch);
    }

    public static String toHex(byte[] b) {
        return Bytes.toHex(b, 0, b.length);
    }

    private static int hexCharToNibble(char ch) {
        if (ch <= '9' && ch >= '0') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex char: " + ch);
    }

    private static byte hexCharsToByte(char c1, char c2) {
        return (byte)(Bytes.hexCharToNibble(c1) << 4 | Bytes.hexCharToNibble(c2));
    }

    public static byte[] fromHex(String hex2) {
        Preconditions.checkArgument(hex2.length() % 2 == 0, "length must be a multiple of 2");
        int len = hex2.length();
        byte[] b = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            b[i2 / 2] = Bytes.hexCharsToByte(hex2.charAt(i2), hex2.charAt(i2 + 1));
        }
        return b;
    }

    public static int searchDelimiterIndex(byte[] b, int offset2, int length2, int delimiter) {
        if (b == null) {
            throw new IllegalArgumentException("Passed buffer is null");
        }
        int result2 = -1;
        for (int i2 = offset2; i2 < length2 + offset2; ++i2) {
            if (b[i2] != delimiter) continue;
            result2 = i2;
            break;
        }
        return result2;
    }

    public static int searchDelimiterIndexInReverse(byte[] b, int offset2, int length2, int delimiter) {
        if (b == null) {
            throw new IllegalArgumentException("Passed buffer is null");
        }
        int result2 = -1;
        for (int i2 = offset2 + length2 - 1; i2 >= offset2; --i2) {
            if (b[i2] != delimiter) continue;
            result2 = i2;
            break;
        }
        return result2;
    }

    public static int findCommonPrefix(byte[] left, byte[] right, int leftLength, int rightLength, int leftOffset, int rightOffset) {
        int result2;
        int length2 = Math.min(leftLength, rightLength);
        for (result2 = 0; result2 < length2 && left[leftOffset + result2] == right[rightOffset + result2]; ++result2) {
        }
        return result2;
    }

    @InterfaceAudience.Private
    static class LexicographicalComparerHolder {
        static final String UNSAFE_COMPARER_NAME = LexicographicalComparerHolder.class.getName() + "$UnsafeComparer";
        static final Comparer<byte[]> BEST_COMPARER = LexicographicalComparerHolder.getBestComparer();

        LexicographicalComparerHolder() {
        }

        static Comparer<byte[]> getBestComparer() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)theClass.getEnumConstants()[0];
                return comparer;
            }
            catch (Throwable t) {
                return Bytes.lexicographicalComparerJavaImpl();
            }
        }

        @InterfaceAudience.Private
        static enum UnsafeComparer implements Comparer<byte[]>
        {
            INSTANCE;

            static final Unsafe theUnsafe;

            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                int i2;
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int stride = 8;
                int minLength = Math.min(length1, length2);
                int strideLimit = minLength & 0xFFFFFFF8;
                long offset1Adj = (long)offset1 + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                long offset2Adj = (long)offset2 + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                for (i2 = 0; i2 < strideLimit; i2 += 8) {
                    long rw;
                    long lw = theUnsafe.getLong(buffer1, offset1Adj + (long)i2);
                    if (lw == (rw = theUnsafe.getLong(buffer2, offset2Adj + (long)i2))) continue;
                    if (!UnsafeAccess.LITTLE_ENDIAN) {
                        return lw + Long.MIN_VALUE < rw + Long.MIN_VALUE ? -1 : 1;
                    }
                    int n = Long.numberOfTrailingZeros(lw ^ rw) & 0xFFFFFFF8;
                    return (int)(lw >>> n & 0xFFL) - (int)(rw >>> n & 0xFFL);
                }
                while (i2 < minLength) {
                    int a = buffer1[offset1 + i2] & 0xFF;
                    int b = buffer2[offset2 + i2] & 0xFF;
                    if (a != b) {
                        return a - b;
                    }
                    ++i2;
                }
                return length1 - length2;
            }

            static {
                if (!UNSAFE_UNALIGNED) {
                    throw new Error();
                }
                theUnsafe = UnsafeAccess.theUnsafe;
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
            }
        }

        static enum PureJavaComparer implements Comparer<byte[]>
        {
            INSTANCE;


            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int end1 = offset1 + length1;
                int end2 = offset2 + length2;
                int i2 = offset1;
                for (int j = offset2; i2 < end1 && j < end2; ++i2, ++j) {
                    int a = buffer1[i2] & 0xFF;
                    int b = buffer2[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }
        }
    }

    static class ConverterHolder {
        static final String UNSAFE_CONVERTER_NAME = ConverterHolder.class.getName() + "$UnsafeConverter";
        static final Converter BEST_CONVERTER = ConverterHolder.getBestConverter();

        ConverterHolder() {
        }

        static Converter getBestConverter() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_CONVERTER_NAME);
                Converter converter = (Converter)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return converter;
            }
            catch (Throwable t) {
                return PureJavaConverter.INSTANCE;
            }
        }

        protected static final class UnsafeConverter
        extends Converter {
            static final Unsafe theUnsafe;

            @Override
            long toLong(byte[] bytes2, int offset2, int length2) {
                return UnsafeAccess.toLong(bytes2, offset2);
            }

            @Override
            int putLong(byte[] bytes2, int offset2, long val) {
                return UnsafeAccess.putLong(bytes2, offset2, val);
            }

            @Override
            int toInt(byte[] bytes2, int offset2, int length2) {
                return UnsafeAccess.toInt(bytes2, offset2);
            }

            @Override
            int putInt(byte[] bytes2, int offset2, int val) {
                return UnsafeAccess.putInt(bytes2, offset2, val);
            }

            @Override
            short toShort(byte[] bytes2, int offset2, int length2) {
                return UnsafeAccess.toShort(bytes2, offset2);
            }

            @Override
            int putShort(byte[] bytes2, int offset2, short val) {
                return UnsafeAccess.putShort(bytes2, offset2, val);
            }

            static {
                if (!UNSAFE_UNALIGNED) {
                    throw new Error();
                }
                theUnsafe = UnsafeAccess.theUnsafe;
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
            }
        }

        protected static final class PureJavaConverter
        extends Converter {
            static final PureJavaConverter INSTANCE = new PureJavaConverter();

            private PureJavaConverter() {
            }

            @Override
            long toLong(byte[] bytes2, int offset2, int length2) {
                long l = 0L;
                for (int i2 = offset2; i2 < offset2 + length2; ++i2) {
                    l <<= 8;
                    l ^= (long)(bytes2[i2] & 0xFF);
                }
                return l;
            }

            @Override
            int putLong(byte[] bytes2, int offset2, long val) {
                for (int i2 = offset2 + 7; i2 > offset2; --i2) {
                    bytes2[i2] = (byte)val;
                    val >>>= 8;
                }
                bytes2[offset2] = (byte)val;
                return offset2 + 8;
            }

            @Override
            int toInt(byte[] bytes2, int offset2, int length2) {
                int n = 0;
                for (int i2 = offset2; i2 < offset2 + length2; ++i2) {
                    n <<= 8;
                    n ^= bytes2[i2] & 0xFF;
                }
                return n;
            }

            @Override
            int putInt(byte[] bytes2, int offset2, int val) {
                for (int i2 = offset2 + 3; i2 > offset2; --i2) {
                    bytes2[i2] = (byte)val;
                    val >>>= 8;
                }
                bytes2[offset2] = (byte)val;
                return offset2 + 4;
            }

            @Override
            short toShort(byte[] bytes2, int offset2, int length2) {
                short n = 0;
                n = (short)((n ^ bytes2[offset2]) & 0xFF);
                n = (short)(n << 8);
                n = (short)(n ^ (short)(bytes2[offset2 + 1] & 0xFF));
                return n;
            }

            @Override
            int putShort(byte[] bytes2, int offset2, short val) {
                bytes2[offset2 + 1] = (byte)val;
                val = (short)(val >> 8);
                bytes2[offset2] = (byte)val;
                return offset2 + 2;
            }
        }
    }

    static abstract class Converter {
        Converter() {
        }

        abstract long toLong(byte[] var1, int var2, int var3);

        abstract int putLong(byte[] var1, int var2, long var3);

        abstract int toInt(byte[] var1, int var2, int var3);

        abstract int putInt(byte[] var1, int var2, int var3);

        abstract short toShort(byte[] var1, int var2, int var3);

        abstract int putShort(byte[] var1, int var2, short var3);
    }

    static interface Comparer<T> {
        public int compareTo(T var1, int var2, int var3, T var4, int var5, int var6);
    }

    @InterfaceAudience.Public
    public static class RowEndKeyComparator
    extends ByteArrayComparator {
        @Override
        public int compare(byte[] left, byte[] right) {
            return this.compare(left, 0, left.length, right, 0, right.length);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            if (b1 == b2 && s1 == s2 && l1 == l2) {
                return 0;
            }
            if (l1 == 0) {
                return l2;
            }
            if (l2 == 0) {
                return -1;
            }
            return super.compare(b1, s1, l1, b2, s2, l2);
        }
    }

    @InterfaceAudience.Public
    public static class ByteArrayComparator
    implements RawComparator<byte[]> {
        public int compare(byte[] left, byte[] right) {
            return Bytes.compareTo(left, right);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return LexicographicalComparerHolder.BEST_COMPARER.compareTo(b1, s1, l1, b2, s2, l2);
        }
    }
}

