/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class CellVisibility {
    private String expression;

    public CellVisibility(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression;
    }

    public static String quote(String auth) {
        return CellVisibility.quote(Bytes.toBytes(auth));
    }

    public static String quote(byte[] auth) {
        int escapeChars = 0;
        for (int i2 = 0; i2 < auth.length; ++i2) {
            if (auth[i2] != 34 && auth[i2] != 92) continue;
            ++escapeChars;
        }
        byte[] escapedAuth = new byte[auth.length + escapeChars + 2];
        int index2 = 1;
        for (int i3 = 0; i3 < auth.length; ++i3) {
            if (auth[i3] == 34 || auth[i3] == 92) {
                escapedAuth[index2++] = 92;
            }
            escapedAuth[index2++] = auth[i3];
        }
        escapedAuth[0] = 34;
        escapedAuth[escapedAuth.length - 1] = 34;
        return Bytes.toString(escapedAuth);
    }
}

