/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import javax.security.sasl.SaslClient;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SaslUnwrapHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final SaslClient saslClient;

    public SaslUnwrapHandler(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        SaslUtil.safeDispose(this.saslClient);
        ctx.fireChannelInactive();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] bytes2 = new byte[msg.readableBytes()];
        msg.readBytes(bytes2);
        ctx.fireChannelRead(Unpooled.wrappedBuffer(this.saslClient.unwrap(bytes2, 0, bytes2.length)));
    }
}

