/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.RefCnt;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.hadoop.hbase.util.UnsafeAccess;
import org.apache.hadoop.hbase.util.UnsafeAvailChecker;
import org.apache.yetus.audience.InterfaceAudience;
import sun.nio.ch.DirectBuffer;

@InterfaceAudience.Private
public class SingleByteBuff
extends ByteBuff {
    private static final boolean UNSAFE_AVAIL = UnsafeAvailChecker.isAvailable();
    private static final boolean UNSAFE_UNALIGNED = UnsafeAvailChecker.unaligned();
    private final ByteBuffer buf;
    private long unsafeOffset;
    private Object unsafeRef = null;

    public SingleByteBuff(ByteBuffer buf) {
        this(ByteBuffAllocator.NONE, buf);
    }

    public SingleByteBuff(ByteBuffAllocator.Recycler recycler, ByteBuffer buf) {
        this(new RefCnt(recycler), buf);
    }

    SingleByteBuff(RefCnt refCnt, ByteBuffer buf) {
        this.refCnt = refCnt;
        this.buf = buf;
        if (buf.hasArray()) {
            this.unsafeOffset = UnsafeAccess.BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset();
            this.unsafeRef = buf.array();
        } else {
            this.unsafeOffset = ((DirectBuffer)((Object)buf)).address();
        }
    }

    @Override
    public int position() {
        this.checkRefCount();
        return this.buf.position();
    }

    @Override
    public SingleByteBuff position(int position) {
        this.checkRefCount();
        this.buf.position(position);
        return this;
    }

    @Override
    public SingleByteBuff skip(int len) {
        this.checkRefCount();
        this.buf.position(this.buf.position() + len);
        return this;
    }

    @Override
    public SingleByteBuff moveBack(int len) {
        this.checkRefCount();
        this.buf.position(this.buf.position() - len);
        return this;
    }

    @Override
    public int capacity() {
        this.checkRefCount();
        return this.buf.capacity();
    }

    @Override
    public int limit() {
        this.checkRefCount();
        return this.buf.limit();
    }

    @Override
    public SingleByteBuff limit(int limit2) {
        this.checkRefCount();
        this.buf.limit(limit2);
        return this;
    }

    @Override
    public SingleByteBuff rewind() {
        this.checkRefCount();
        this.buf.rewind();
        return this;
    }

    @Override
    public SingleByteBuff mark() {
        this.checkRefCount();
        this.buf.mark();
        return this;
    }

    @Override
    public ByteBuffer asSubByteBuffer(int length2) {
        this.checkRefCount();
        return this.buf;
    }

    @Override
    public void asSubByteBuffer(int offset2, int length2, ObjectIntPair<ByteBuffer> pair) {
        this.checkRefCount();
        pair.setFirst(this.buf);
        pair.setSecond(offset2);
    }

    @Override
    public int remaining() {
        this.checkRefCount();
        return this.buf.remaining();
    }

    @Override
    public boolean hasRemaining() {
        this.checkRefCount();
        return this.buf.hasRemaining();
    }

    @Override
    public SingleByteBuff reset() {
        this.checkRefCount();
        this.buf.reset();
        return this;
    }

    @Override
    public SingleByteBuff slice() {
        this.checkRefCount();
        return new SingleByteBuff(this.refCnt, this.buf.slice());
    }

    @Override
    public SingleByteBuff duplicate() {
        this.checkRefCount();
        return new SingleByteBuff(this.refCnt, this.buf.duplicate());
    }

    @Override
    public byte get() {
        this.checkRefCount();
        return this.buf.get();
    }

    @Override
    public byte get(int index2) {
        this.checkRefCount();
        if (UNSAFE_AVAIL) {
            return UnsafeAccess.toByte(this.unsafeRef, this.unsafeOffset + (long)index2);
        }
        return this.buf.get(index2);
    }

    @Override
    public byte getByteAfterPosition(int offset2) {
        this.checkRefCount();
        return this.get(this.buf.position() + offset2);
    }

    @Override
    public SingleByteBuff put(byte b) {
        this.checkRefCount();
        this.buf.put(b);
        return this;
    }

    @Override
    public SingleByteBuff put(int index2, byte b) {
        this.checkRefCount();
        this.buf.put(index2, b);
        return this;
    }

    @Override
    public void get(byte[] dst, int offset2, int length2) {
        this.checkRefCount();
        ByteBufferUtils.copyFromBufferToArray(dst, this.buf, this.buf.position(), offset2, length2);
        this.buf.position(this.buf.position() + length2);
    }

    @Override
    public void get(int sourceOffset, byte[] dst, int offset2, int length2) {
        this.checkRefCount();
        ByteBufferUtils.copyFromBufferToArray(dst, this.buf, sourceOffset, offset2, length2);
    }

    @Override
    public void get(byte[] dst) {
        this.get(dst, 0, dst.length);
    }

    @Override
    public SingleByteBuff put(int offset2, ByteBuff src, int srcOffset, int length2) {
        this.checkRefCount();
        if (src instanceof SingleByteBuff) {
            ByteBufferUtils.copyFromBufferToBuffer(((SingleByteBuff)src).buf, this.buf, srcOffset, offset2, length2);
        } else {
            ObjectIntPair<ByteBuffer> pair = new ObjectIntPair<ByteBuffer>();
            src.asSubByteBuffer(srcOffset, length2, pair);
            if (pair.getFirst() != null) {
                ByteBufferUtils.copyFromBufferToBuffer(pair.getFirst(), this.buf, pair.getSecond(), offset2, length2);
            }
        }
        return this;
    }

    @Override
    public SingleByteBuff put(byte[] src, int offset2, int length2) {
        this.checkRefCount();
        ByteBufferUtils.copyFromArrayToBuffer(this.buf, src, offset2, length2);
        return this;
    }

    @Override
    public SingleByteBuff put(byte[] src) {
        this.checkRefCount();
        return this.put(src, 0, src.length);
    }

    @Override
    public boolean hasArray() {
        this.checkRefCount();
        return this.buf.hasArray();
    }

    @Override
    public byte[] array() {
        this.checkRefCount();
        return this.buf.array();
    }

    @Override
    public int arrayOffset() {
        this.checkRefCount();
        return this.buf.arrayOffset();
    }

    @Override
    public short getShort() {
        this.checkRefCount();
        return this.buf.getShort();
    }

    @Override
    public short getShort(int index2) {
        this.checkRefCount();
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toShort(this.unsafeRef, this.unsafeOffset + (long)index2);
        }
        return this.buf.getShort(index2);
    }

    @Override
    public short getShortAfterPosition(int offset2) {
        this.checkRefCount();
        return this.getShort(this.buf.position() + offset2);
    }

    @Override
    public int getInt() {
        this.checkRefCount();
        return this.buf.getInt();
    }

    @Override
    public SingleByteBuff putInt(int value2) {
        this.checkRefCount();
        ByteBufferUtils.putInt(this.buf, value2);
        return this;
    }

    @Override
    public int getInt(int index2) {
        this.checkRefCount();
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toInt(this.unsafeRef, this.unsafeOffset + (long)index2);
        }
        return this.buf.getInt(index2);
    }

    @Override
    public int getIntAfterPosition(int offset2) {
        this.checkRefCount();
        return this.getInt(this.buf.position() + offset2);
    }

    @Override
    public long getLong() {
        this.checkRefCount();
        return this.buf.getLong();
    }

    @Override
    public SingleByteBuff putLong(long value2) {
        this.checkRefCount();
        ByteBufferUtils.putLong(this.buf, value2);
        return this;
    }

    @Override
    public long getLong(int index2) {
        this.checkRefCount();
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toLong(this.unsafeRef, this.unsafeOffset + (long)index2);
        }
        return this.buf.getLong(index2);
    }

    @Override
    public long getLongAfterPosition(int offset2) {
        this.checkRefCount();
        return this.getLong(this.buf.position() + offset2);
    }

    @Override
    public byte[] toBytes(int offset2, int length2) {
        this.checkRefCount();
        byte[] output = new byte[length2];
        ByteBufferUtils.copyFromBufferToArray(output, this.buf, offset2, 0, length2);
        return output;
    }

    @Override
    public void get(ByteBuffer out, int sourceOffset, int length2) {
        this.checkRefCount();
        ByteBufferUtils.copyFromBufferToBuffer(this.buf, out, sourceOffset, length2);
    }

    @Override
    public int read(ReadableByteChannel channel) throws IOException {
        this.checkRefCount();
        return SingleByteBuff.read(channel, this.buf, 0L, CHANNEL_READER);
    }

    @Override
    public int read(FileChannel channel, long offset2) throws IOException {
        this.checkRefCount();
        return SingleByteBuff.read(channel, this.buf, offset2, FILE_READER);
    }

    @Override
    public int write(FileChannel channel, long offset2) throws IOException {
        this.checkRefCount();
        int total2 = 0;
        while (this.buf.hasRemaining()) {
            int len = channel.write(this.buf, offset2);
            total2 += len;
            offset2 += (long)len;
        }
        return total2;
    }

    @Override
    public ByteBuffer[] nioByteBuffers() {
        this.checkRefCount();
        return new ByteBuffer[]{this.buf};
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SingleByteBuff)) {
            return false;
        }
        return this.buf.equals(((SingleByteBuff)obj).buf);
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    @Override
    public SingleByteBuff retain() {
        this.refCnt.retain();
        return this;
    }
}

