/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallCancelledException;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.ipc.ServerTooBusyException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FastThreadLocal;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class IPCUtil {
    private static final FastThreadLocal<MutableInt> DEPTH = new FastThreadLocal<MutableInt>(){

        @Override
        protected MutableInt initialValue() throws Exception {
            return new MutableInt(0);
        }
    };
    static final int MAX_DEPTH = 4;

    IPCUtil() {
    }

    public static int write(OutputStream dos, Message header, Message param, ByteBuf cellBlock) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param);
        if (cellBlock != null) {
            totalSize += cellBlock.readableBytes();
        }
        return IPCUtil.write(dos, header, param, cellBlock, totalSize);
    }

    private static int write(OutputStream dos, Message header, Message param, ByteBuf cellBlock, int totalSize) throws IOException {
        dos.write(Bytes.toBytes(totalSize));
        header.writeDelimitedTo(dos);
        if (param != null) {
            param.writeDelimitedTo(dos);
        }
        if (cellBlock != null) {
            cellBlock.readBytes(dos, cellBlock.readableBytes());
        }
        dos.flush();
        return totalSize;
    }

    public static int getTotalSizeWhenWrittenDelimited(Message ... messages) {
        int totalSize = 0;
        for (Message m : messages) {
            if (m == null) continue;
            totalSize += m.getSerializedSize();
            totalSize += CodedOutputStream.computeUInt32SizeNoTag(m.getSerializedSize());
        }
        Preconditions.checkArgument(totalSize < Integer.MAX_VALUE);
        return totalSize;
    }

    static RPCProtos.RequestHeader buildRequestHeader(Call call2, RPCProtos.CellBlockMeta cellBlockMeta) {
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        builder.setCallId(call2.id);
        builder.setMethodName(call2.md.getName());
        builder.setRequestParam(call2.param != null);
        if (cellBlockMeta != null) {
            builder.setCellBlockMeta(cellBlockMeta);
        }
        if (call2.priority != -1) {
            builder.setPriority(call2.priority);
        }
        builder.setTimeout(call2.timeout);
        return builder.build();
    }

    static RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
        String innerExceptionClassName = e.getExceptionClassName();
        boolean doNotRetry = e.getDoNotRetry();
        return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
    }

    static boolean isFatalConnectionException(RPCProtos.ExceptionResponse e) {
        return e.getExceptionClassName().equals(FatalConnectionException.class.getName());
    }

    static IOException toIOE(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        return new IOException(t);
    }

    private static String getCallTarget(InetSocketAddress addr2, RegionInfo regionInfo) {
        return "address=" + addr2 + (regionInfo != null ? ", region=" + regionInfo.getRegionNameAsString() : "");
    }

    static IOException wrapException(InetSocketAddress addr2, RegionInfo regionInfo, Throwable error2) {
        if (error2 instanceof ConnectException) {
            return (IOException)new ConnectException("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on connection exception: " + error2).initCause(error2);
        }
        if (error2 instanceof SocketTimeoutException) {
            return (IOException)new SocketTimeoutException("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed because " + error2).initCause(error2);
        }
        if (error2 instanceof ConnectionClosingException) {
            return new ConnectionClosingException("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on local exception: " + error2, error2);
        }
        if (error2 instanceof ServerTooBusyException) {
            return (IOException)error2;
        }
        if (error2 instanceof DoNotRetryIOException) {
            try {
                return (IOException)error2.getClass().asSubclass(DoNotRetryIOException.class).getConstructor(String.class).newInstance("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on local exception: " + error2).initCause(error2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception2) {
                return new DoNotRetryIOException("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on local exception: " + error2, error2);
            }
        }
        if (error2 instanceof ConnectionClosedException) {
            return new ConnectionClosedException("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on local exception: " + error2, error2);
        }
        if (error2 instanceof CallTimeoutException) {
            return new CallTimeoutException("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on local exception: " + error2, error2);
        }
        if (error2 instanceof ClosedChannelException) {
            return (IOException)error2;
        }
        if (error2 instanceof TimeoutException) {
            return new TimeoutIOException("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on local exception: " + error2, error2);
        }
        if (error2 instanceof IOException) {
            try {
                return (IOException)error2.getClass().asSubclass(IOException.class).getConstructor(String.class).newInstance("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on local exception: " + error2).initCause(error2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception3) {
                // empty catch block
            }
        }
        return new HBaseIOException("Call to " + IPCUtil.getCallTarget(addr2, regionInfo) + " failed on local exception: " + error2, error2);
    }

    static void setCancelled(Call call2) {
        call2.setException(new CallCancelledException(call2.toShortString() + ", waitTime=" + (EnvironmentEdgeManager.currentTime() - call2.getStartTime()) + ", rpcTimeout=" + call2.timeout));
    }

    static void execute(EventLoop eventLoop, Runnable action) {
        if (eventLoop.inEventLoop()) {
            MutableInt depth = DEPTH.get();
            if (depth.intValue() < 4) {
                depth.increment();
                try {
                    action.run();
                }
                finally {
                    depth.decrement();
                }
            } else {
                eventLoop.execute(action);
            }
        } else {
            eventLoop.execute(action);
        }
    }
}

