/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface Dictionary {
    public static final byte NOT_IN_DICTIONARY = -1;

    public void init(int var1);

    public byte[] getEntry(short var1);

    public short findEntry(byte[] var1, int var2, int var3);

    public short findEntry(ByteBuffer var1, int var2, int var3);

    public short addEntry(byte[] var1, int var2, int var3);

    public void clear();

    public static void write(OutputStream out, byte[] data, int offset2, int length2, Dictionary dict) throws IOException {
        short dictIdx = -1;
        if (dict != null) {
            dictIdx = dict.findEntry(data, offset2, length2);
        }
        if (dictIdx == -1) {
            out.write(-1);
            StreamUtils.writeRawVInt32(out, length2);
            out.write(data, offset2, length2);
        } else {
            StreamUtils.writeShort(out, dictIdx);
        }
    }

    public static void write(OutputStream out, ByteBuffer data, int offset2, int length2, Dictionary dict) throws IOException {
        short dictIdx = -1;
        if (dict != null) {
            dictIdx = dict.findEntry(data, offset2, length2);
        }
        if (dictIdx == -1) {
            out.write(-1);
            StreamUtils.writeRawVInt32(out, length2);
            ByteBufferUtils.copyBufferToStream(out, data, offset2, length2);
        } else {
            StreamUtils.writeShort(out, dictIdx);
        }
    }
}

