/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class WhileMatchFilter
extends FilterBase {
    private boolean filterAllRemaining = false;
    private Filter filter;

    public WhileMatchFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void reset() throws IOException {
        this.filter.reset();
    }

    private void changeFAR(boolean value2) {
        this.filterAllRemaining = this.filterAllRemaining || value2;
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        return this.filterAllRemaining || this.filter.filterAllRemaining();
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset2, int length2) throws IOException {
        boolean value2 = this.filter.filterRowKey(buffer, offset2, length2);
        this.changeFAR(value2);
        return value2;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        if (this.filterAllRemaining()) {
            return true;
        }
        boolean value2 = this.filter.filterRowKey(cell);
        this.changeFAR(value2);
        return value2;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) throws IOException {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        Filter.ReturnCode code = this.filter.filterCell(c);
        this.changeFAR(code != Filter.ReturnCode.INCLUDE);
        return code;
    }

    @Override
    public Cell transformCell(Cell v) throws IOException {
        return this.filter.transformCell(v);
    }

    @Override
    public boolean filterRow() throws IOException {
        boolean filterRow = this.filter.filterRow();
        this.changeFAR(filterRow);
        return filterRow;
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        FilterProtos.WhileMatchFilter.Builder builder = FilterProtos.WhileMatchFilter.newBuilder();
        builder.setFilter(ProtobufUtil.toFilter(this.filter));
        return builder.build().toByteArray();
    }

    public static WhileMatchFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.WhileMatchFilter proto;
        try {
            proto = FilterProtos.WhileMatchFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        try {
            return new WhileMatchFilter(ProtobufUtil.toFilter(proto.getFilter()));
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhileMatchFilter)) {
            return false;
        }
        WhileMatchFilter other = (WhileMatchFilter)o;
        return this.getFilter().areSerializedFieldsEqual(other.getFilter());
    }

    @Override
    public boolean isFamilyEssential(byte[] name2) throws IOException {
        return this.filter.isFamilyEssential(name2);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.filter.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(this.filter);
    }
}

