/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ColumnCountGetFilter
extends FilterBase {
    private int limit = 0;
    private int count = 0;

    public ColumnCountGetFilter(int n) {
        Preconditions.checkArgument(n >= 0, "limit be positive %s", n);
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterAllRemaining() {
        return this.count > this.limit;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        ++this.count;
        return this.filterAllRemaining() ? Filter.ReturnCode.NEXT_COL : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 1, "Expected 1 but got: %s", filterArguments.size());
        int limit2 = ParseFilter.convertByteArrayToInt(filterArguments.get(0));
        return new ColumnCountGetFilter(limit2);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnCountGetFilter.Builder builder = FilterProtos.ColumnCountGetFilter.newBuilder();
        builder.setLimit(this.limit);
        return builder.build().toByteArray();
    }

    public static ColumnCountGetFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnCountGetFilter proto;
        try {
            proto = FilterProtos.ColumnCountGetFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new ColumnCountGetFilter(proto.getLimit());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnCountGetFilter)) {
            return false;
        }
        ColumnCountGetFilter other = (ColumnCountGetFilter)o;
        return this.getLimit() == other.getLimit();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.limit;
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(this.limit);
    }
}

