/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class TableCFs {
    private final TableName table;
    private final Map<String, Integer> cfs;

    public TableCFs(TableName table, Map<String, Integer> cfs) {
        this.table = table;
        this.cfs = cfs;
    }

    public TableName getTable() {
        return this.table;
    }

    public Map<String, Integer> getColumnFamilyMap() {
        return this.cfs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.table.getNameAsString());
        if (!this.cfs.isEmpty()) {
            sb.append(":");
            sb.append(StringUtils.join(this.cfs.keySet(), ','));
        }
        return sb.toString();
    }
}

