/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Attributes;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class OperationWithAttributes
extends Operation
implements Attributes {
    private Map<String, byte[]> attributes;
    public static final String ID_ATRIBUTE = "_operation.attributes.id";
    private int priority = -1;

    protected OperationWithAttributes() {
    }

    protected OperationWithAttributes(OperationWithAttributes clone) {
        this.attributes = clone.getAttributesMap() == null ? null : (Map)clone.getAttributesMap().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (byte[])e.getValue(), (k, v) -> {
            throw new RuntimeException("collisions!!!");
        }, () -> new TreeMap()));
        this.priority = clone.getPriority();
    }

    @Override
    public OperationWithAttributes setAttribute(String name2, byte[] value2) {
        if (this.attributes == null && value2 == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, byte[]>();
        }
        if (value2 == null) {
            this.attributes.remove(name2);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            this.attributes.put(name2, value2);
        }
        return this;
    }

    @Override
    public byte[] getAttribute(String name2) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name2);
    }

    @Override
    public Map<String, byte[]> getAttributesMap() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    protected long getAttributeSize() {
        long size2 = 0L;
        if (this.attributes != null) {
            size2 += (long)ClassSize.align(this.attributes.size() * ClassSize.MAP_ENTRY);
            for (Map.Entry<String, byte[]> entry : this.attributes.entrySet()) {
                size2 += (long)ClassSize.align(ClassSize.STRING + entry.getKey().length());
                size2 += (long)ClassSize.align(ClassSize.ARRAY + entry.getValue().length);
            }
        }
        return size2;
    }

    public OperationWithAttributes setId(String id2) {
        this.setAttribute(ID_ATRIBUTE, Bytes.toBytes(id2));
        return this;
    }

    public String getId() {
        byte[] attr2 = this.getAttribute(ID_ATRIBUTE);
        return attr2 == null ? null : Bytes.toString(attr2);
    }

    public OperationWithAttributes setPriority(int priority2) {
        this.priority = priority2;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }
}

