/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncConnectionConfiguration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class AsyncAdminBuilderBase
implements AsyncAdminBuilder {
    protected long rpcTimeoutNs;
    protected long operationTimeoutNs;
    protected long pauseNs;
    protected long pauseForCQTBENs;
    protected int maxAttempts;
    protected int startLogErrorsCnt;

    AsyncAdminBuilderBase(AsyncConnectionConfiguration connConf) {
        this.rpcTimeoutNs = connConf.getRpcTimeoutNs();
        this.operationTimeoutNs = connConf.getOperationTimeoutNs();
        this.pauseNs = connConf.getPauseNs();
        this.pauseForCQTBENs = connConf.getPauseForCQTBENs();
        this.maxAttempts = connConf.getMaxRetries();
        this.startLogErrorsCnt = connConf.getStartLogErrorsCnt();
    }

    @Override
    public AsyncAdminBuilder setOperationTimeout(long timeout2, TimeUnit unit) {
        this.operationTimeoutNs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncAdminBuilder setRpcTimeout(long timeout2, TimeUnit unit) {
        this.rpcTimeoutNs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncAdminBuilder setRetryPause(long timeout2, TimeUnit unit) {
        this.pauseNs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncAdminBuilder setRetryPauseForCQTBE(long timeout2, TimeUnit unit) {
        this.pauseForCQTBENs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncAdminBuilder setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    @Override
    public AsyncAdminBuilder setStartLogErrorsCnt(int startLogErrorsCnt) {
        this.startLogErrorsCnt = startLogErrorsCnt;
        return this;
    }
}

