/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface Tag {
    public static final int TYPE_LENGTH_SIZE = 1;
    public static final int TAG_LENGTH_SIZE = 2;
    public static final int INFRASTRUCTURE_SIZE = 3;
    public static final int MAX_TAG_LENGTH = 65533;
    public static final byte CUSTOM_TAG_TYPE_RANGE = 64;

    public byte getType();

    public int getValueOffset();

    public int getValueLength();

    public boolean hasArray();

    public byte[] getValueArray();

    public ByteBuffer getValueByteBuffer();

    public static byte[] cloneValue(Tag tag2) {
        int tagLength = tag2.getValueLength();
        byte[] tagArr = new byte[tagLength];
        if (tag2.hasArray()) {
            Bytes.putBytes(tagArr, 0, tag2.getValueArray(), tag2.getValueOffset(), tagLength);
        } else {
            ByteBufferUtils.copyFromBufferToArray(tagArr, tag2.getValueByteBuffer(), tag2.getValueOffset(), 0, tagLength);
        }
        return tagArr;
    }

    public static String getValueAsString(Tag tag2) {
        if (tag2.hasArray()) {
            return Bytes.toString(tag2.getValueArray(), tag2.getValueOffset(), tag2.getValueLength());
        }
        return Bytes.toString(Tag.cloneValue(tag2));
    }

    public static boolean matchingValue(Tag t1, Tag t2) {
        if (t1.hasArray() && t2.hasArray()) {
            return Bytes.equals(t1.getValueArray(), t1.getValueOffset(), t1.getValueLength(), t2.getValueArray(), t2.getValueOffset(), t2.getValueLength());
        }
        if (t1.hasArray()) {
            return ByteBufferUtils.equals(t2.getValueByteBuffer(), t2.getValueOffset(), t2.getValueLength(), t1.getValueArray(), t1.getValueOffset(), t1.getValueLength());
        }
        if (t2.hasArray()) {
            return ByteBufferUtils.equals(t1.getValueByteBuffer(), t1.getValueOffset(), t1.getValueLength(), t2.getValueArray(), t2.getValueOffset(), t2.getValueLength());
        }
        return ByteBufferUtils.equals(t1.getValueByteBuffer(), t1.getValueOffset(), t1.getValueLength(), t2.getValueByteBuffer(), t2.getValueOffset(), t2.getValueLength());
    }

    public static void copyValueTo(Tag tag2, byte[] out, int offset2) {
        if (tag2.hasArray()) {
            Bytes.putBytes(out, offset2, tag2.getValueArray(), tag2.getValueOffset(), tag2.getValueLength());
        } else {
            ByteBufferUtils.copyFromBufferToArray(out, tag2.getValueByteBuffer(), tag2.getValueOffset(), offset2, tag2.getValueLength());
        }
    }

    public static long getValueAsLong(Tag tag2) {
        if (tag2.hasArray()) {
            return Bytes.toLong(tag2.getValueArray(), tag2.getValueOffset(), tag2.getValueLength());
        }
        return ByteBufferUtils.toLong(tag2.getValueByteBuffer(), tag2.getValueOffset());
    }

    public static byte getValueAsByte(Tag tag2) {
        if (tag2.hasArray()) {
            return tag2.getValueArray()[tag2.getValueOffset()];
        }
        return ByteBufferUtils.toByte(tag2.getValueByteBuffer(), tag2.getValueOffset());
    }
}

