/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.exceptions;

import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.messages.KrbError;

public class KerberosException
extends Exception {
    private static final long serialVersionUID = 2968072183596955597L;
    private KrbError error;
    private final int errorCode;
    private byte[] explanatoryData;

    public KerberosException(ErrorType errorType) {
        super(errorType.getMessage());
        this.errorCode = errorType.getValue();
    }

    public KerberosException(KrbError error2) {
        super(error2.getMessageType().getMessage());
        this.errorCode = error2.getErrorCode().getValue();
        this.error = error2;
    }

    public KerberosException(ErrorType errorType, Throwable cause2) {
        super(errorType.getMessage(), cause2);
        this.errorCode = errorType.getValue();
    }

    public KerberosException(ErrorType errorType, String msg) {
        super(msg);
        this.errorCode = errorType.getValue();
    }

    public KerberosException(ErrorType errorType, String msg, Throwable cause2) {
        super(msg, cause2);
        this.errorCode = errorType.getValue();
    }

    public KerberosException(ErrorType errorType, byte[] explanatoryData) {
        super(errorType.getMessage());
        this.errorCode = errorType.getValue();
        this.explanatoryData = explanatoryData;
    }

    public KerberosException(ErrorType errorType, byte[] explanatoryData, Throwable cause2) {
        super(errorType.getMessage(), cause2);
        this.errorCode = errorType.getValue();
        this.explanatoryData = explanatoryData;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public byte[] getExplanatoryData() {
        return this.explanatoryData;
    }

    protected KerberosException(int errorCode, String msg) {
        super(msg);
        this.errorCode = errorCode;
    }

    protected KerberosException(int errorCode, String msg, Throwable cause2) {
        super(msg, cause2);
        this.errorCode = errorCode;
    }

    protected KerberosException(int errorCode, String msg, byte[] explanatoryData) {
        super(msg);
        this.errorCode = errorCode;
        this.explanatoryData = explanatoryData;
    }

    protected KerberosException(int errorCode, String msg, byte[] explanatoryData, Throwable cause2) {
        super(msg, cause2);
        this.errorCode = errorCode;
        this.explanatoryData = explanatoryData;
    }

    public KrbError getError() {
        return this.error;
    }
}

