/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.asn1.util.BitString;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.HostAddresses;
import org.apache.directory.shared.kerberos.components.LastReq;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.flags.TicketFlags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncKdcRepPart
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(EncKdcRepPart.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private EncryptionKey key;
    private LastReq lastReq;
    private int nonce;
    private KerberosTime keyExpiration;
    private TicketFlags flags = new TicketFlags();
    private KerberosTime authTime;
    private KerberosTime startTime;
    private KerberosTime endTime;
    private KerberosTime renewTill;
    private String srealm;
    private PrincipalName sname;
    private HostAddresses caddr;
    private int keyLength;
    private int lastReqLength;
    private int nonceLength;
    private int flagsLength;
    private byte[] srealmBytes;
    private int srealmLength;
    private int snameLength;
    private int caddrLength;
    private int encKdcRepPartSeqLength;

    public KerberosTime getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(KerberosTime time) {
        this.authTime = time;
    }

    public HostAddresses getClientAddresses() {
        return this.caddr;
    }

    public void setClientAddresses(HostAddresses caddr) {
        this.caddr = caddr;
    }

    public KerberosTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(KerberosTime time) {
        this.endTime = time;
    }

    public TicketFlags getFlags() {
        return this.flags;
    }

    public void setFlags(TicketFlags flags) {
        this.flags = flags;
    }

    public EncryptionKey getKey() {
        return this.key;
    }

    public void setKey(EncryptionKey key2) {
        this.key = key2;
    }

    public KerberosTime getKeyExpiration() {
        return this.keyExpiration;
    }

    public void setKeyExpiration(KerberosTime expiration) {
        this.keyExpiration = expiration;
    }

    public LastReq getLastReq() {
        return this.lastReq;
    }

    public void setLastReq(LastReq lastReq) {
        this.lastReq = lastReq;
    }

    public int getNonce() {
        return this.nonce;
    }

    public void setNonce(int nonce) {
        this.nonce = nonce;
    }

    public KerberosTime getRenewTill() {
        return this.renewTill;
    }

    public void setRenewTill(KerberosTime till) {
        this.renewTill = till;
    }

    public PrincipalName getSName() {
        return this.sname;
    }

    public void setSName(PrincipalName sname) {
        this.sname = sname;
    }

    public String getSRealm() {
        return this.srealm;
    }

    public void setSRealm(String srealm) {
        this.srealm = srealm;
    }

    public KerberosTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(KerberosTime time) {
        this.startTime = time;
    }

    @Override
    public int computeLength() {
        this.keyLength = this.key.computeLength();
        this.encKdcRepPartSeqLength = 1 + TLV.getNbBytes((int)this.keyLength) + this.keyLength;
        this.lastReqLength = this.lastReq.computeLength();
        this.encKdcRepPartSeqLength += 1 + TLV.getNbBytes((int)this.lastReqLength) + this.lastReqLength;
        this.nonceLength = BerValue.getNbBytes((int)this.nonce);
        this.nonceLength = 1 + TLV.getNbBytes((int)this.nonceLength) + this.nonceLength;
        this.encKdcRepPartSeqLength += 1 + TLV.getNbBytes((int)this.nonceLength) + this.nonceLength;
        if (this.keyExpiration != null) {
            this.encKdcRepPartSeqLength += 19;
        }
        this.flagsLength = 7;
        this.encKdcRepPartSeqLength += 1 + TLV.getNbBytes((int)this.flagsLength) + this.flagsLength;
        this.encKdcRepPartSeqLength += 19;
        if (this.startTime != null) {
            this.encKdcRepPartSeqLength += 19;
        }
        this.encKdcRepPartSeqLength += 19;
        if (this.renewTill != null) {
            this.encKdcRepPartSeqLength += 19;
        }
        this.srealmBytes = this.srealm.getBytes();
        this.srealmLength = 1 + TLV.getNbBytes((int)this.srealmBytes.length) + this.srealmBytes.length;
        this.encKdcRepPartSeqLength += 1 + TLV.getNbBytes((int)this.srealmLength) + this.srealmLength;
        this.snameLength = this.sname.computeLength();
        this.encKdcRepPartSeqLength += 1 + TLV.getNbBytes((int)this.snameLength) + this.snameLength;
        if (this.caddr != null) {
            this.caddrLength = this.caddr.computeLength();
            this.encKdcRepPartSeqLength += 1 + TLV.getNbBytes((int)this.caddrLength) + this.caddrLength;
        }
        return 1 + TLV.getNbBytes((int)this.encKdcRepPartSeqLength) + this.encKdcRepPartSeqLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.encKdcRepPartSeqLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.keyLength));
            this.key.encode(buffer);
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.lastReqLength));
            this.lastReq.encode(buffer);
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes((int)this.nonceLength));
            BerValue.encode((ByteBuffer)buffer, (int)this.nonce);
            if (this.keyExpiration != null) {
                buffer.put((byte)-93);
                buffer.put(TLV.getBytes((int)17));
                buffer.put(UniversalTag.GENERALIZED_TIME.getValue());
                buffer.put((byte)15);
                buffer.put(this.keyExpiration.getBytes());
            }
            buffer.put((byte)-92);
            buffer.put(TLV.getBytes((int)7));
            BerValue.encode((ByteBuffer)buffer, (BitString)this.flags);
            buffer.put((byte)-91);
            buffer.put(TLV.getBytes((int)17));
            buffer.put(UniversalTag.GENERALIZED_TIME.getValue());
            buffer.put((byte)15);
            buffer.put(this.authTime.getBytes());
            if (this.startTime != null) {
                buffer.put((byte)-90);
                buffer.put(TLV.getBytes((int)17));
                buffer.put(UniversalTag.GENERALIZED_TIME.getValue());
                buffer.put((byte)15);
                buffer.put(this.startTime.getBytes());
            }
            buffer.put((byte)-89);
            buffer.put(TLV.getBytes((int)17));
            buffer.put(UniversalTag.GENERALIZED_TIME.getValue());
            buffer.put((byte)15);
            buffer.put(this.endTime.getBytes());
            if (this.renewTill != null) {
                buffer.put((byte)-88);
                buffer.put(TLV.getBytes((int)17));
                buffer.put(UniversalTag.GENERALIZED_TIME.getValue());
                buffer.put((byte)15);
                buffer.put(this.renewTill.getBytes());
            }
            buffer.put((byte)-87);
            buffer.put(TLV.getBytes((int)this.srealmLength));
            buffer.put(UniversalTag.GENERAL_STRING.getValue());
            buffer.put(TLV.getBytes((int)this.srealmBytes.length));
            buffer.put(this.srealmBytes);
            buffer.put((byte)-86);
            buffer.put(TLV.getBytes((int)this.snameLength));
            this.sname.encode(buffer);
            if (this.caddr != null) {
                buffer.put((byte)-85);
                buffer.put(TLV.getBytes((int)this.caddrLength));
                this.caddr.encode(buffer);
            }
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err(I18n.ERR_140, 1 + TLV.getNbBytes((int)0) + 0, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("EncKdcRepPart encoding : {}", (Object)Strings.dumpBytes(buffer.array()));
            log.debug("EncKdcRepPart initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EncKdcRepPart : \n");
        sb.append("    key : ").append(this.key).append("\n");
        sb.append("    last-req : ").append(this.lastReq).append("\n");
        sb.append("    nonce : ").append(this.nonce).append("\n");
        if (this.keyExpiration != null) {
            sb.append("    key-expiration : ").append(this.keyExpiration).append("\n");
        }
        sb.append("    flags : ").append(this.flags).append("\n");
        sb.append("    authtime : ").append(this.authTime).append("\n");
        if (this.startTime != null) {
            sb.append("    starttime : ").append(this.startTime).append("\n");
        }
        sb.append("    endtime : ").append(this.endTime).append("\n");
        if (this.renewTill != null) {
            sb.append("    renew-till : ").append(this.renewTill).append("\n");
        }
        sb.append("    srealm : ").append(this.srealm).append("\n");
        sb.append("    sname : ").append(this.sname).append("\n");
        if (this.caddr != null) {
            sb.append("    caddr : ").append(this.caddr).append("\n");
        }
        return sb.toString();
    }
}

