/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;

public class Des3CbcSha1KdEncryption
extends EncryptionEngine
implements ChecksumEngine {
    private static final byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public EncryptionType getEncryptionType() {
        return EncryptionType.DES3_CBC_SHA1_KD;
    }

    @Override
    public int getConfounderLength() {
        return 8;
    }

    @Override
    public int getChecksumLength() {
        return 20;
    }

    @Override
    public ChecksumType checksumType() {
        return ChecksumType.HMAC_SHA1_DES3_KD;
    }

    @Override
    public byte[] calculateChecksum(byte[] data, byte[] key2, KeyUsage usage) {
        byte[] Kc = this.deriveKey(key2, this.getUsageKc(usage), 64, 168);
        return this.processChecksum(data, Kc);
    }

    @Override
    public byte[] calculateIntegrity(byte[] data, byte[] key2, KeyUsage usage) {
        byte[] Ki = this.deriveKey(key2, this.getUsageKi(usage), 64, 168);
        return this.processChecksum(data, Ki);
    }

    @Override
    public byte[] getDecryptedData(EncryptionKey key2, EncryptedData data, KeyUsage usage) throws KerberosException {
        byte[] Ke = this.deriveKey(key2.getKeyValue(), this.getUsageKe(usage), 64, 168);
        byte[] encryptedData = data.getCipher();
        byte[] oldChecksum = new byte[this.getChecksumLength()];
        System.arraycopy(encryptedData, encryptedData.length - this.getChecksumLength(), oldChecksum, 0, oldChecksum.length);
        encryptedData = this.removeTrailingBytes(encryptedData, 0, this.getChecksumLength());
        byte[] decryptedData = this.decrypt(encryptedData, Ke);
        byte[] withoutConfounder = this.removeLeadingBytes(decryptedData, this.getConfounderLength(), 0);
        byte[] newChecksum = this.calculateIntegrity(decryptedData, key2.getKeyValue(), usage);
        if (!Arrays.equals(oldChecksum, newChecksum)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
        }
        return withoutConfounder;
    }

    @Override
    public EncryptedData getEncryptedData(EncryptionKey key2, byte[] plainText, KeyUsage usage) {
        byte[] Ke = this.deriveKey(key2.getKeyValue(), this.getUsageKe(usage), 64, 168);
        byte[] conFounder = this.getRandomBytes(this.getConfounderLength());
        byte[] paddedPlainText = this.padString(plainText);
        byte[] dataBytes = this.concatenateBytes(conFounder, paddedPlainText);
        byte[] checksumBytes = this.calculateIntegrity(dataBytes, key2.getKeyValue(), usage);
        byte[] encryptedData = this.encrypt(dataBytes, Ke);
        byte[] cipherText = this.concatenateBytes(encryptedData, checksumBytes);
        return new EncryptedData(this.getEncryptionType(), key2.getKeyVersion(), cipherText);
    }

    @Override
    public byte[] encrypt(byte[] plainText, byte[] keyBytes) {
        return this.processCipher(true, plainText, keyBytes);
    }

    @Override
    public byte[] decrypt(byte[] cipherText, byte[] keyBytes) {
        return this.processCipher(false, cipherText, keyBytes);
    }

    protected byte[] deriveKey(byte[] baseKey, byte[] usage, int n, int k) {
        byte[] result2 = this.deriveRandom(baseKey, usage, n, k);
        result2 = this.randomToKey(result2);
        return result2;
    }

    protected byte[] randomToKey(byte[] seed2) {
        int kBytes = 24;
        byte[] result2 = new byte[kBytes];
        byte[] fillingKey = Strings.EMPTY_BYTES;
        int pos2 = 0;
        for (int i2 = 0; i2 < kBytes; ++i2) {
            if (pos2 < fillingKey.length) {
                result2[i2] = fillingKey[pos2];
                ++pos2;
                continue;
            }
            fillingKey = this.getBitGroup(seed2, i2 / 8);
            fillingKey = this.setParity(fillingKey);
            pos2 = 0;
            result2[i2] = fillingKey[pos2];
            ++pos2;
        }
        return result2;
    }

    protected byte[] getBitGroup(byte[] seed2, int group2) {
        int srcPos = group2 * 7;
        byte[] result2 = new byte[7];
        System.arraycopy(seed2, srcPos, result2, 0, 7);
        return result2;
    }

    protected byte[] setParity(byte[] in) {
        byte[] expandedIn = new byte[8];
        System.arraycopy(in, 0, expandedIn, 0, in.length);
        this.setBit(expandedIn, 62, this.getBit(in, 7));
        this.setBit(expandedIn, 61, this.getBit(in, 15));
        this.setBit(expandedIn, 60, this.getBit(in, 23));
        this.setBit(expandedIn, 59, this.getBit(in, 31));
        this.setBit(expandedIn, 58, this.getBit(in, 39));
        this.setBit(expandedIn, 57, this.getBit(in, 47));
        this.setBit(expandedIn, 56, this.getBit(in, 55));
        byte[] out = new byte[8];
        int bitCount = 0;
        int index2 = 0;
        for (int i2 = 0; i2 < 64; ++i2) {
            boolean bit;
            if ((i2 + 1) % 8 == 0) {
                if (bitCount % 2 == 0) {
                    this.setBit(out, i2, 1);
                }
                ++index2;
                bitCount = 0;
                continue;
            }
            int val = this.getBit(expandedIn, index2);
            boolean bl = bit = val > 0;
            if (bit) {
                this.setBit(out, i2, val);
                ++bitCount;
            }
            ++index2;
        }
        return out;
    }

    private byte[] processCipher(boolean isEncrypt, byte[] data, byte[] keyBytes) {
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            SecretKeySpec key2 = new SecretKeySpec(keyBytes, "DESede");
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            if (isEncrypt) {
                cipher.init(1, (Key)key2, paramSpec);
            } else {
                cipher.init(2, (Key)key2, paramSpec);
            }
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException nsae) {
            nsae.printStackTrace();
            return null;
        }
    }

    private byte[] processChecksum(byte[] data, byte[] key2) {
        try {
            SecretKeySpec sk = new SecretKeySpec(key2, "DESede");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(sk);
            return mac.doFinal(data);
        }
        catch (GeneralSecurityException nsae) {
            nsae.printStackTrace();
            return null;
        }
    }
}

