/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.io.Externalizable;
import org.apache.directory.api.util.SequencedHashMap;

public final class SynchronizedLRUMap
extends SequencedHashMap
implements Externalizable {
    private static final long serialVersionUID = 2197433140769957051L;
    private int maximumSize = 0;

    public SynchronizedLRUMap() {
        this(100);
    }

    public SynchronizedLRUMap(int i2) {
        super(i2);
        this.maximumSize = i2;
    }

    @Override
    public synchronized Object get(Object key2) {
        if (!this.containsKey(key2)) {
            return null;
        }
        Object value2 = this.remove(key2);
        super.put(key2, value2);
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key2, Object value2) {
        int mapSize = this.size();
        Object retval = null;
        if (mapSize >= this.maximumSize) {
            SynchronizedLRUMap synchronizedLRUMap = this;
            synchronized (synchronizedLRUMap) {
                if (!this.containsKey(key2)) {
                    this.removeLRU();
                }
                retval = super.put(key2, value2);
            }
        }
        SynchronizedLRUMap synchronizedLRUMap = this;
        synchronized (synchronizedLRUMap) {
            retval = super.put(key2, value2);
        }
        return retval;
    }

    private void removeLRU() {
        Object key2 = this.getFirstKey();
        super.get(key2);
        this.remove(key2);
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumSize(int maximumSize) {
        SynchronizedLRUMap synchronizedLRUMap = this;
        synchronized (synchronizedLRUMap) {
            this.maximumSize = maximumSize;
            while (this.size() > maximumSize) {
                this.removeLRU();
            }
        }
    }
}

