/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ZKPaths;

class NamespaceImpl {
    private final CuratorFrameworkImpl client;
    private final String namespace;
    private final EnsurePath ensurePath;

    NamespaceImpl(CuratorFrameworkImpl client, String namespace) {
        if (namespace != null) {
            try {
                PathUtils.validatePath("/" + namespace);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid namespace: " + namespace);
            }
        }
        this.client = client;
        this.namespace = namespace;
        this.ensurePath = namespace != null ? new EnsurePath(ZKPaths.makePath("/", namespace)) : null;
    }

    String getNamespace() {
        return this.namespace;
    }

    String unfixForNamespace(String path2) {
        String namespacePath;
        if (this.namespace != null && path2 != null && path2.startsWith(namespacePath = ZKPaths.makePath(this.namespace, null))) {
            path2 = path2.length() > namespacePath.length() ? path2.substring(namespacePath.length()) : "/";
        }
        return path2;
    }

    String fixForNamespace(String path2, boolean isSequential) {
        if (this.ensurePath != null) {
            try {
                this.ensurePath.ensure(this.client.getZookeeperClient());
            }
            catch (Exception e) {
                this.client.logError("Ensure path threw exception", e);
            }
        }
        return ZKPaths.fixForNamespace(this.namespace, path2, isSequential);
    }

    EnsurePath newNamespaceAwareEnsurePath(String path2) {
        return new EnsurePath(this.fixForNamespace(path2, false), this.client.getAclProvider());
    }
}

