/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.utils;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.crypto.cipher.CryptoCipher;

public final class ReflectionUtils {
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();
    private static final ClassLoader CLASSLOADER;
    private static final Class<?> NEGATIVE_CACHE_SENTINEL;

    private ReflectionUtils() {
    }

    public static <T> T newInstance(Class<T> klass, Object ... args2) {
        try {
            Constructor<T> ctor;
            if (args2.length == 0) {
                ctor = klass.getDeclaredConstructor(new Class[0]);
            } else {
                Class[] argClses = new Class[args2.length];
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    argClses[i2] = args2[i2].getClass();
                }
                ctor = klass.getDeclaredConstructor(argClses);
            }
            ctor.setAccessible(true);
            return ctor.newInstance(args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getClassByName(String name2) throws ClassNotFoundException {
        Class<?> ret = ReflectionUtils.getClassByNameOrNull(name2);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name2 + " not found");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClassByNameOrNull(String name2) {
        Map<String, WeakReference<Class<Object>>> map;
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = CACHE_CLASSES;
        synchronized (map2) {
            map = CACHE_CLASSES.get(CLASSLOADER);
            if (map == null) {
                map = Collections.synchronizedMap(new WeakHashMap());
                CACHE_CLASSES.put(CLASSLOADER, map);
            }
        }
        Class<?> clazz = null;
        WeakReference<Class<Object>> ref = map.get(name2);
        if (ref != null) {
            clazz = (Class<?>)ref.get();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name2, true, CLASSLOADER);
            }
            catch (ClassNotFoundException e) {
                map.put(name2, new WeakReference(NEGATIVE_CACHE_SENTINEL));
                return null;
            }
            map.put(name2, new WeakReference(clazz));
            return clazz;
        }
        if (clazz == NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return clazz;
    }

    static {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        CLASSLOADER = threadClassLoader != null ? threadClassLoader : CryptoCipher.class.getClassLoader();
        NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }
}

