/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.crypto.stream.input.Input;

public final class IoUtils {
    private IoUtils() {
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static void readFully(Input in, long position, byte[] buffer, int offset2, int length2) throws IOException {
        int nbytes;
        for (int nread = 0; nread < length2; nread += nbytes) {
            nbytes = in.read(position + (long)nread, buffer, offset2 + nread, length2 - nread);
            if (nbytes >= 0) continue;
            throw new IOException("End of stream reached before reading fully.");
        }
    }

    public static void cleanup(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

