/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.crypto.stream.input.Input;

public class StreamInput
implements Input {
    private final byte[] buf;
    private final int bufferSize;
    final InputStream in;

    public StreamInput(InputStream inputStream, int bufferSize) {
        this.in = inputStream;
        this.bufferSize = bufferSize;
        this.buf = new byte[bufferSize];
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int remaining = dst.remaining();
        int read2 = 0;
        while (remaining > 0) {
            int n = this.in.read(this.buf, 0, Math.min(remaining, this.bufferSize));
            if (n == -1) {
                if (read2 != 0) break;
                read2 = -1;
                break;
            }
            if (n <= 0) continue;
            dst.put(this.buf, 0, n);
            read2 += n;
            remaining -= n;
        }
        return read2;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read(long position, byte[] buffer, int offset2, int length2) throws IOException {
        throw new UnsupportedOperationException("Positioned read is not supported by this implementation");
    }

    @Override
    public void seek(long position) throws IOException {
        throw new UnsupportedOperationException("Seek is not supported by this implementation");
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

