/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.output.ChannelOutput;
import org.apache.commons.crypto.stream.output.Output;
import org.apache.commons.crypto.stream.output.StreamOutput;
import org.apache.commons.crypto.utils.Utils;

public class CryptoOutputStream
extends OutputStream
implements WritableByteChannel {
    private final byte[] oneByteBuf = new byte[1];
    Output output;
    final CryptoCipher cipher;
    final int bufferSize;
    final Key key;
    final AlgorithmParameterSpec params;
    private boolean closed;
    ByteBuffer inBuffer;
    ByteBuffer outBuffer;

    public CryptoOutputStream(String transformation, Properties props, OutputStream out, Key key2, AlgorithmParameterSpec params2) throws IOException {
        this(out, Utils.getCipherInstance(transformation, props), CryptoInputStream.getBufferSize(props), key2, params2);
    }

    public CryptoOutputStream(String transformation, Properties props, WritableByteChannel out, Key key2, AlgorithmParameterSpec params2) throws IOException {
        this(out, Utils.getCipherInstance(transformation, props), CryptoInputStream.getBufferSize(props), key2, params2);
    }

    protected CryptoOutputStream(OutputStream out, CryptoCipher cipher, int bufferSize, Key key2, AlgorithmParameterSpec params2) throws IOException {
        this(new StreamOutput(out, bufferSize), cipher, bufferSize, key2, params2);
    }

    protected CryptoOutputStream(WritableByteChannel channel, CryptoCipher cipher, int bufferSize, Key key2, AlgorithmParameterSpec params2) throws IOException {
        this(new ChannelOutput(channel), cipher, bufferSize, key2, params2);
    }

    protected CryptoOutputStream(Output output, CryptoCipher cipher, int bufferSize, Key key2, AlgorithmParameterSpec params2) throws IOException {
        this.output = output;
        this.bufferSize = CryptoInputStream.checkBufferSize(cipher, bufferSize);
        this.cipher = cipher;
        this.key = key2;
        this.params = params2;
        if (!(params2 instanceof IvParameterSpec)) {
            throw new IOException("Illegal parameters");
        }
        this.inBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        this.outBuffer = ByteBuffer.allocateDirect(this.bufferSize + cipher.getBlockSize());
        this.initCipher();
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByteBuf[0] = (byte)(b & 0xFF);
        this.write(this.oneByteBuf, 0, this.oneByteBuf.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int remaining = this.inBuffer.remaining();
            if (len < remaining) {
                this.inBuffer.put(b, off, len);
                len = 0;
                continue;
            }
            this.inBuffer.put(b, off, remaining);
            off += remaining;
            len -= remaining;
            this.encrypt();
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkStream();
        this.encrypt();
        this.output.flush();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.encryptFinal();
            this.output.close();
            this.freeBuffers();
            this.cipher.close();
            super.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int len;
        this.checkStream();
        int remaining = len = src.remaining();
        while (remaining > 0) {
            int space = this.inBuffer.remaining();
            if (remaining < space) {
                this.inBuffer.put(src);
                remaining = 0;
                continue;
            }
            int oldLimit = src.limit();
            int newLimit = src.position() + space;
            src.limit(newLimit);
            this.inBuffer.put(src);
            src.limit(oldLimit);
            remaining -= space;
            this.encrypt();
        }
        return len;
    }

    protected void initCipher() throws IOException {
        try {
            this.cipher.init(1, this.key, this.params);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e);
        }
    }

    protected void encrypt() throws IOException {
        this.inBuffer.flip();
        this.outBuffer.clear();
        try {
            this.cipher.update(this.inBuffer, this.outBuffer);
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        this.inBuffer.clear();
        this.outBuffer.flip();
        this.output.write(this.outBuffer);
    }

    protected void encryptFinal() throws IOException {
        this.inBuffer.flip();
        this.outBuffer.clear();
        try {
            this.cipher.doFinal(this.inBuffer, this.outBuffer);
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        catch (BadPaddingException e) {
            throw new IOException(e);
        }
        this.inBuffer.clear();
        this.outBuffer.flip();
        this.output.write(this.outBuffer);
    }

    protected void checkStream() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    protected void freeBuffers() {
        CryptoInputStream.freeDirectBuffer(this.inBuffer);
        CryptoInputStream.freeDirectBuffer(this.outBuffer);
    }

    protected ByteBuffer getOutBuffer() {
        return this.outBuffer;
    }

    protected CryptoCipher getCipher() {
        return this.cipher;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected ByteBuffer getInBuffer() {
        return this.inBuffer;
    }
}

