/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.random;

import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.OpenSslCryptoRandomNative;
import org.apache.commons.crypto.utils.Utils;

class OpenSslCryptoRandom
extends Random
implements CryptoRandom {
    private static final long serialVersionUID = -7828193502768789584L;
    private static final boolean nativeEnabled;
    private static final Throwable initException;

    public static boolean isNativeCodeEnabled() {
        return nativeEnabled;
    }

    public OpenSslCryptoRandom(Properties props) throws GeneralSecurityException {
        if (!nativeEnabled) {
            if (initException != null) {
                throw new GeneralSecurityException("Native library could not be initialised", initException);
            }
            throw new GeneralSecurityException("Native library is not loaded");
        }
        if (!OpenSslCryptoRandomNative.nextRandBytes(new byte[1])) {
            throw new GeneralSecurityException("Check of nextRandBytes failed");
        }
    }

    @Override
    public void nextBytes(byte[] bytes2) {
        if (!OpenSslCryptoRandomNative.nextRandBytes(bytes2)) {
            throw new IllegalArgumentException("The nextRandBytes method failed");
        }
    }

    @Override
    public void setSeed(long seed2) {
    }

    @Override
    protected final int next(int numBits) {
        Utils.checkArgument(numBits >= 0 && numBits <= 32);
        int numBytes = (numBits + 7) / 8;
        byte[] b = new byte[numBytes];
        int next2 = 0;
        this.nextBytes(b);
        for (int i2 = 0; i2 < numBytes; ++i2) {
            next2 = (next2 << 8) + (b[i2] & 0xFF);
        }
        return next2 >>> numBytes * 8 - numBits;
    }

    @Override
    public void close() {
    }

    static {
        boolean opensslLoaded = false;
        Throwable except = null;
        if (Crypto.isNativeCodeLoaded()) {
            try {
                OpenSslCryptoRandomNative.initSR();
                opensslLoaded = true;
            }
            catch (Exception t) {
                except = t;
            }
            catch (UnsatisfiedLinkError t) {
                except = t;
            }
        }
        nativeEnabled = opensslLoaded;
        initException = except;
    }
}

