/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.cipher.OpenSsl;
import org.apache.commons.crypto.utils.Utils;

class OpenSslCipher
implements CryptoCipher {
    private final OpenSsl cipher;
    private final String transformation;

    public OpenSslCipher(Properties props, String transformation) throws GeneralSecurityException {
        this.transformation = transformation;
        Throwable loadingFailureReason = OpenSsl.getLoadingFailureReason();
        if (loadingFailureReason != null) {
            throw new RuntimeException(loadingFailureReason);
        }
        this.cipher = OpenSsl.getInstance(transformation);
    }

    @Override
    public final int getBlockSize() {
        return 16;
    }

    @Override
    public String getAlgorithm() {
        return this.transformation;
    }

    @Override
    public void init(int mode2, Key key2, AlgorithmParameterSpec params2) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Utils.checkNotNull(key2);
        Utils.checkNotNull(params2);
        int cipherMode = 0;
        if (mode2 == 1) {
            cipherMode = 1;
        }
        if (!(params2 instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Illegal parameters");
        }
        byte[] iv = ((IvParameterSpec)params2).getIV();
        this.cipher.init(cipherMode, key2.getEncoded(), iv);
    }

    @Override
    public int update(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        return this.cipher.update(inBuffer, outBuffer);
    }

    @Override
    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    public int doFinal(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = this.cipher.update(inBuffer, outBuffer);
        return n + this.cipher.doFinal(outBuffer);
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
        return n + this.cipher.doFinal(output, outputOffset + n);
    }

    @Override
    public void close() {
        this.cipher.clean();
    }
}

