/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.RecyclableArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CompositeByteBuf
extends AbstractReferenceCountedByteBuf
implements Iterable<ByteBuf> {
    private static final ByteBuffer EMPTY_NIO_BUFFER = Unpooled.EMPTY_BUFFER.nioBuffer();
    private static final Iterator<ByteBuf> EMPTY_ITERATOR = Collections.emptyList().iterator();
    private final ByteBufAllocator alloc;
    private final boolean direct;
    private final int maxNumComponents;
    private int componentCount;
    private Component[] components;
    private boolean freed;
    static final ByteWrapper<byte[]> BYTE_ARRAY_WRAPPER = new ByteWrapper<byte[]>(){

        @Override
        public ByteBuf wrap(byte[] bytes2) {
            return Unpooled.wrappedBuffer(bytes2);
        }

        @Override
        public boolean isEmpty(byte[] bytes2) {
            return bytes2.length == 0;
        }
    };
    static final ByteWrapper<ByteBuffer> BYTE_BUFFER_WRAPPER = new ByteWrapper<ByteBuffer>(){

        @Override
        public ByteBuf wrap(ByteBuffer bytes2) {
            return Unpooled.wrappedBuffer(bytes2);
        }

        @Override
        public boolean isEmpty(ByteBuffer bytes2) {
            return !bytes2.hasRemaining();
        }
    };
    private Component lastAccessed;

    private CompositeByteBuf(ByteBufAllocator alloc2, boolean direct, int maxNumComponents, int initSize) {
        super(Integer.MAX_VALUE);
        this.alloc = ObjectUtil.checkNotNull(alloc2, "alloc");
        if (maxNumComponents < 1) {
            throw new IllegalArgumentException("maxNumComponents: " + maxNumComponents + " (expected: >= 1)");
        }
        this.direct = direct;
        this.maxNumComponents = maxNumComponents;
        this.components = CompositeByteBuf.newCompArray(initSize, maxNumComponents);
    }

    public CompositeByteBuf(ByteBufAllocator alloc2, boolean direct, int maxNumComponents) {
        this(alloc2, direct, maxNumComponents, 0);
    }

    public CompositeByteBuf(ByteBufAllocator alloc2, boolean direct, int maxNumComponents, ByteBuf ... buffers) {
        this(alloc2, direct, maxNumComponents, buffers, 0);
    }

    CompositeByteBuf(ByteBufAllocator alloc2, boolean direct, int maxNumComponents, ByteBuf[] buffers, int offset2) {
        this(alloc2, direct, maxNumComponents, buffers.length - offset2);
        this.addComponents0(false, 0, buffers, offset2);
        this.consolidateIfNeeded();
        this.setIndex0(0, this.capacity());
    }

    public CompositeByteBuf(ByteBufAllocator alloc2, boolean direct, int maxNumComponents, Iterable<ByteBuf> buffers) {
        this(alloc2, direct, maxNumComponents, buffers instanceof Collection ? ((Collection)buffers).size() : 0);
        this.addComponents(false, 0, buffers);
        this.setIndex(0, this.capacity());
    }

    <T> CompositeByteBuf(ByteBufAllocator alloc2, boolean direct, int maxNumComponents, ByteWrapper<T> wrapper, T[] buffers, int offset2) {
        this(alloc2, direct, maxNumComponents, buffers.length - offset2);
        this.addComponents0(false, 0, wrapper, buffers, offset2);
        this.consolidateIfNeeded();
        this.setIndex(0, this.capacity());
    }

    private static Component[] newCompArray(int initComponents, int maxNumComponents) {
        int capacityGuess = Math.min(16, maxNumComponents);
        return new Component[Math.max(initComponents, capacityGuess)];
    }

    CompositeByteBuf(ByteBufAllocator alloc2) {
        super(Integer.MAX_VALUE);
        this.alloc = alloc2;
        this.direct = false;
        this.maxNumComponents = 0;
        this.components = null;
    }

    public CompositeByteBuf addComponent(ByteBuf buffer) {
        return this.addComponent(false, buffer);
    }

    public CompositeByteBuf addComponents(ByteBuf ... buffers) {
        return this.addComponents(false, buffers);
    }

    public CompositeByteBuf addComponents(Iterable<ByteBuf> buffers) {
        return this.addComponents(false, buffers);
    }

    public CompositeByteBuf addComponent(int cIndex, ByteBuf buffer) {
        return this.addComponent(false, cIndex, buffer);
    }

    public CompositeByteBuf addComponent(boolean increaseWriterIndex, ByteBuf buffer) {
        return this.addComponent(increaseWriterIndex, this.componentCount, buffer);
    }

    public CompositeByteBuf addComponents(boolean increaseWriterIndex, ByteBuf ... buffers) {
        ObjectUtil.checkNotNull(buffers, "buffers");
        this.addComponents0(increaseWriterIndex, this.componentCount, buffers, 0);
        this.consolidateIfNeeded();
        return this;
    }

    public CompositeByteBuf addComponents(boolean increaseWriterIndex, Iterable<ByteBuf> buffers) {
        return this.addComponents(increaseWriterIndex, this.componentCount, buffers);
    }

    public CompositeByteBuf addComponent(boolean increaseWriterIndex, int cIndex, ByteBuf buffer) {
        ObjectUtil.checkNotNull(buffer, "buffer");
        this.addComponent0(increaseWriterIndex, cIndex, buffer);
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addComponent0(boolean increaseWriterIndex, int cIndex, ByteBuf buffer) {
        assert (buffer != null);
        boolean wasAdded = false;
        try {
            this.checkComponentIndex(cIndex);
            Component c = this.newComponent(CompositeByteBuf.ensureAccessible(buffer), 0);
            int readableBytes = c.length();
            this.addComp(cIndex, c);
            wasAdded = true;
            if (readableBytes > 0 && cIndex < this.componentCount - 1) {
                this.updateComponentOffsets(cIndex);
            } else if (cIndex > 0) {
                c.reposition(this.components[cIndex - 1].endOffset);
            }
            if (increaseWriterIndex) {
                this.writerIndex += readableBytes;
            }
            int n = cIndex;
            return n;
        }
        finally {
            if (!wasAdded) {
                buffer.release();
            }
        }
    }

    private static ByteBuf ensureAccessible(ByteBuf buf) {
        if (checkAccessible && !buf.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
        return buf;
    }

    private Component newComponent(ByteBuf buf, int offset2) {
        int srcIndex = buf.readerIndex();
        int len = buf.readableBytes();
        ByteBuf unwrapped = buf;
        int unwrappedIndex = srcIndex;
        while (unwrapped instanceof WrappedByteBuf || unwrapped instanceof SwappedByteBuf) {
            unwrapped = unwrapped.unwrap();
        }
        if (unwrapped instanceof AbstractUnpooledSlicedByteBuf) {
            unwrappedIndex += ((AbstractUnpooledSlicedByteBuf)unwrapped).idx(0);
            unwrapped = unwrapped.unwrap();
        } else if (unwrapped instanceof PooledSlicedByteBuf) {
            unwrappedIndex += ((PooledSlicedByteBuf)unwrapped).adjustment;
            unwrapped = unwrapped.unwrap();
        } else if (unwrapped instanceof DuplicatedByteBuf || unwrapped instanceof PooledDuplicatedByteBuf) {
            unwrapped = unwrapped.unwrap();
        }
        ByteBuf slice = buf.capacity() == len ? buf : null;
        return new Component(buf.order(ByteOrder.BIG_ENDIAN), srcIndex, unwrapped.order(ByteOrder.BIG_ENDIAN), unwrappedIndex, offset2, len, slice);
    }

    public CompositeByteBuf addComponents(int cIndex, ByteBuf ... buffers) {
        ObjectUtil.checkNotNull(buffers, "buffers");
        this.addComponents0(false, cIndex, buffers, 0);
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeByteBuf addComponents0(boolean increaseWriterIndex, int cIndex, ByteBuf[] buffers, int arrOffset) {
        int len = buffers.length;
        int count2 = len - arrOffset;
        int ci = Integer.MAX_VALUE;
        try {
            ByteBuf b;
            this.checkComponentIndex(cIndex);
            this.shiftComps(cIndex, count2);
            int nextOffset = cIndex > 0 ? this.components[cIndex - 1].endOffset : 0;
            ci = cIndex;
            while (arrOffset < len && (b = buffers[arrOffset]) != null) {
                Component c;
                this.components[ci] = c = this.newComponent(CompositeByteBuf.ensureAccessible(b), nextOffset);
                nextOffset = c.endOffset;
                ++arrOffset;
                ++ci;
            }
            CompositeByteBuf compositeByteBuf = this;
            return compositeByteBuf;
        }
        finally {
            if (ci < this.componentCount) {
                if (ci < cIndex + count2) {
                    this.removeCompRange(ci, cIndex + count2);
                    while (arrOffset < len) {
                        ReferenceCountUtil.safeRelease(buffers[arrOffset]);
                        ++arrOffset;
                    }
                }
                this.updateComponentOffsets(ci);
            }
            if (increaseWriterIndex && ci > cIndex && ci <= this.componentCount) {
                this.writerIndex += this.components[ci - 1].endOffset - this.components[cIndex].offset;
            }
        }
    }

    private <T> int addComponents0(boolean increaseWriterIndex, int cIndex, ByteWrapper<T> wrapper, T[] buffers, int offset2) {
        T b;
        this.checkComponentIndex(cIndex);
        int len = buffers.length;
        for (int i2 = offset2; i2 < len && (b = buffers[i2]) != null; ++i2) {
            int size2;
            if (wrapper.isEmpty(b) || (cIndex = this.addComponent0(increaseWriterIndex, cIndex, wrapper.wrap(b)) + 1) <= (size2 = this.componentCount)) continue;
            cIndex = size2;
        }
        return cIndex;
    }

    public CompositeByteBuf addComponents(int cIndex, Iterable<ByteBuf> buffers) {
        return this.addComponents(false, cIndex, buffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeByteBuf addFlattenedComponents(boolean increaseWriterIndex, ByteBuf buffer) {
        ObjectUtil.checkNotNull(buffer, "buffer");
        int ridx = buffer.readerIndex();
        int widx = buffer.writerIndex();
        if (ridx == widx) {
            buffer.release();
            return this;
        }
        if (!(buffer instanceof CompositeByteBuf)) {
            this.addComponent0(increaseWriterIndex, this.componentCount, buffer);
            this.consolidateIfNeeded();
            return this;
        }
        CompositeByteBuf from = (CompositeByteBuf)buffer;
        from.checkIndex(ridx, widx - ridx);
        Component[] fromComponents = from.components;
        int compCountBefore = this.componentCount;
        int writerIndexBefore = this.writerIndex;
        try {
            int cidx = from.toComponentIndex0(ridx);
            int newOffset = this.capacity();
            while (true) {
                Component component = fromComponents[cidx];
                int compOffset = component.offset;
                int fromIdx = Math.max(ridx, compOffset);
                int toIdx = Math.min(widx, component.endOffset);
                int len = toIdx - fromIdx;
                if (len > 0) {
                    this.addComp(this.componentCount, new Component(component.srcBuf.retain(), component.srcIdx(fromIdx), component.buf, component.idx(fromIdx), newOffset, len, null));
                }
                if (widx == toIdx) break;
                newOffset += len;
                ++cidx;
            }
            if (increaseWriterIndex) {
                this.writerIndex = writerIndexBefore + (widx - ridx);
            }
            this.consolidateIfNeeded();
            buffer.release();
            buffer = null;
            CompositeByteBuf compositeByteBuf = this;
            return compositeByteBuf;
        }
        finally {
            if (buffer != null) {
                if (increaseWriterIndex) {
                    this.writerIndex = writerIndexBefore;
                }
                for (int cidx = this.componentCount - 1; cidx >= compCountBefore; --cidx) {
                    this.components[cidx].free();
                    this.removeComp(cidx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeByteBuf addComponents(boolean increaseIndex, int cIndex, Iterable<ByteBuf> buffers) {
        if (buffers instanceof ByteBuf) {
            return this.addComponent(increaseIndex, cIndex, (ByteBuf)((Object)buffers));
        }
        ObjectUtil.checkNotNull(buffers, "buffers");
        Iterator<ByteBuf> it = buffers.iterator();
        try {
            this.checkComponentIndex(cIndex);
            while (it.hasNext()) {
                ByteBuf b = it.next();
                if (b == null) {
                    break;
                }
                cIndex = this.addComponent0(increaseIndex, cIndex, b) + 1;
                cIndex = Math.min(cIndex, this.componentCount);
            }
        }
        finally {
            while (it.hasNext()) {
                ReferenceCountUtil.safeRelease(it.next());
            }
        }
        this.consolidateIfNeeded();
        return this;
    }

    private void consolidateIfNeeded() {
        int size2 = this.componentCount;
        if (size2 > this.maxNumComponents) {
            this.consolidate0(0, size2);
        }
    }

    private void checkComponentIndex(int cIndex) {
        this.ensureAccessible();
        if (cIndex < 0 || cIndex > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d (expected: >= 0 && <= numComponents(%d))", cIndex, this.componentCount));
        }
    }

    private void checkComponentIndex(int cIndex, int numComponents) {
        this.ensureAccessible();
        if (cIndex < 0 || cIndex + numComponents > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d, numComponents: %d (expected: cIndex >= 0 && cIndex + numComponents <= totalNumComponents(%d))", cIndex, numComponents, this.componentCount));
        }
    }

    private void updateComponentOffsets(int cIndex) {
        int nextIndex;
        int size2 = this.componentCount;
        if (size2 <= cIndex) {
            return;
        }
        int n = nextIndex = cIndex > 0 ? this.components[cIndex - 1].endOffset : 0;
        while (cIndex < size2) {
            Component c = this.components[cIndex];
            c.reposition(nextIndex);
            nextIndex = c.endOffset;
            ++cIndex;
        }
    }

    public CompositeByteBuf removeComponent(int cIndex) {
        this.checkComponentIndex(cIndex);
        Component comp = this.components[cIndex];
        if (this.lastAccessed == comp) {
            this.lastAccessed = null;
        }
        comp.free();
        this.removeComp(cIndex);
        if (comp.length() > 0) {
            this.updateComponentOffsets(cIndex);
        }
        return this;
    }

    public CompositeByteBuf removeComponents(int cIndex, int numComponents) {
        this.checkComponentIndex(cIndex, numComponents);
        if (numComponents == 0) {
            return this;
        }
        int endIndex = cIndex + numComponents;
        boolean needsUpdate = false;
        for (int i2 = cIndex; i2 < endIndex; ++i2) {
            Component c = this.components[i2];
            if (c.length() > 0) {
                needsUpdate = true;
            }
            if (this.lastAccessed == c) {
                this.lastAccessed = null;
            }
            c.free();
        }
        this.removeCompRange(cIndex, endIndex);
        if (needsUpdate) {
            this.updateComponentOffsets(cIndex);
        }
        return this;
    }

    @Override
    public Iterator<ByteBuf> iterator() {
        this.ensureAccessible();
        return this.componentCount == 0 ? EMPTY_ITERATOR : new CompositeByteBufIterator();
    }

    @Override
    protected int forEachByteAsc0(int start2, int end2, ByteProcessor processor) throws Exception {
        if (end2 <= start2) {
            return -1;
        }
        int i2 = this.toComponentIndex0(start2);
        int length2 = end2 - start2;
        while (length2 > 0) {
            Component c = this.components[i2];
            if (c.offset != c.endOffset) {
                int result2;
                ByteBuf s2 = c.buf;
                int localStart = c.idx(start2);
                int localLength = Math.min(length2, c.endOffset - start2);
                int n = result2 = s2 instanceof AbstractByteBuf ? ((AbstractByteBuf)s2).forEachByteAsc0(localStart, localStart + localLength, processor) : s2.forEachByte(localStart, localLength, processor);
                if (result2 != -1) {
                    return result2 - c.adjustment;
                }
                start2 += localLength;
                length2 -= localLength;
            }
            ++i2;
        }
        return -1;
    }

    @Override
    protected int forEachByteDesc0(int rStart, int rEnd, ByteProcessor processor) throws Exception {
        if (rEnd > rStart) {
            return -1;
        }
        int i2 = this.toComponentIndex0(rStart);
        int length2 = 1 + rStart - rEnd;
        while (length2 > 0) {
            Component c = this.components[i2];
            if (c.offset != c.endOffset) {
                int result2;
                ByteBuf s2 = c.buf;
                int localRStart = c.idx(length2 + rEnd);
                int localLength = Math.min(length2, localRStart);
                int localIndex = localRStart - localLength;
                int n = result2 = s2 instanceof AbstractByteBuf ? ((AbstractByteBuf)s2).forEachByteDesc0(localRStart - 1, localIndex, processor) : s2.forEachByteDesc(localIndex, localLength, processor);
                if (result2 != -1) {
                    return result2 - c.adjustment;
                }
                length2 -= localLength;
            }
            --i2;
        }
        return -1;
    }

    public List<ByteBuf> decompose(int offset2, int length2) {
        ByteBuf slice;
        this.checkIndex(offset2, length2);
        if (length2 == 0) {
            return Collections.emptyList();
        }
        int componentId = this.toComponentIndex0(offset2);
        int bytesToSlice = length2;
        Component firstC = this.components[componentId];
        if ((bytesToSlice -= (slice = firstC.buf.slice(firstC.idx(offset2), Math.min(firstC.endOffset - offset2, bytesToSlice))).readableBytes()) == 0) {
            return Collections.singletonList(slice);
        }
        ArrayList<ByteBuf> sliceList = new ArrayList<ByteBuf>(this.componentCount - componentId);
        sliceList.add(slice);
        do {
            Component component = this.components[++componentId];
            slice = component.buf.slice(component.idx(component.offset), Math.min(component.length(), bytesToSlice));
            sliceList.add(slice);
        } while ((bytesToSlice -= slice.readableBytes()) > 0);
        return sliceList;
    }

    @Override
    public boolean isDirect() {
        int size2 = this.componentCount;
        if (size2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < size2; ++i2) {
            if (this.components[i2].buf.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasArray() {
        switch (this.componentCount) {
            case 0: {
                return true;
            }
            case 1: {
                return this.components[0].buf.hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.componentCount) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.components[0].buf.array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        switch (this.componentCount) {
            case 0: {
                return 0;
            }
            case 1: {
                Component c = this.components[0];
                return c.idx(c.buf.arrayOffset());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.components[0].buf.hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public long memoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                Component c = this.components[0];
                return c.buf.memoryAddress() + (long)c.adjustment;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        int size2 = this.componentCount;
        return size2 > 0 ? this.components[size2 - 1].endOffset : 0;
    }

    @Override
    public CompositeByteBuf capacity(int newCapacity) {
        this.checkNewCapacity(newCapacity);
        int size2 = this.componentCount;
        int oldCapacity = this.capacity();
        if (newCapacity > oldCapacity) {
            int paddingLength = newCapacity - oldCapacity;
            ByteBuf padding = this.allocBuffer(paddingLength).setIndex(0, paddingLength);
            this.addComponent0(false, size2, padding);
            if (this.componentCount >= this.maxNumComponents) {
                this.consolidateIfNeeded();
            }
        } else if (newCapacity < oldCapacity) {
            int i2;
            this.lastAccessed = null;
            int bytesToTrim = oldCapacity - newCapacity;
            for (i2 = size2 - 1; i2 >= 0; --i2) {
                Component c = this.components[i2];
                int cLength = c.length();
                if (bytesToTrim < cLength) {
                    c.endOffset -= bytesToTrim;
                    ByteBuf slice = c.slice;
                    if (slice == null) break;
                    c.slice = slice.slice(0, c.length());
                    break;
                }
                c.free();
                bytesToTrim -= cLength;
            }
            this.removeCompRange(i2 + 1, size2);
            if (this.readerIndex() > newCapacity) {
                this.setIndex0(newCapacity, newCapacity);
            } else if (this.writerIndex > newCapacity) {
                this.writerIndex = newCapacity;
            }
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public int numComponents() {
        return this.componentCount;
    }

    public int maxNumComponents() {
        return this.maxNumComponents;
    }

    public int toComponentIndex(int offset2) {
        this.checkIndex(offset2);
        return this.toComponentIndex0(offset2);
    }

    private int toComponentIndex0(int offset2) {
        int size2 = this.componentCount;
        if (offset2 == 0) {
            for (int i2 = 0; i2 < size2; ++i2) {
                if (this.components[i2].endOffset <= 0) continue;
                return i2;
            }
        }
        if (size2 <= 2) {
            return size2 == 1 || offset2 < this.components[0].endOffset ? 0 : 1;
        }
        int low = 0;
        int high = size2;
        while (low <= high) {
            int mid = low + high >>> 1;
            Component c = this.components[mid];
            if (offset2 >= c.endOffset) {
                low = mid + 1;
                continue;
            }
            if (offset2 < c.offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        throw new Error("should not reach here");
    }

    public int toByteIndex(int cIndex) {
        this.checkComponentIndex(cIndex);
        return this.components[cIndex].offset;
    }

    @Override
    public byte getByte(int index2) {
        Component c = this.findComponent(index2);
        return c.buf.getByte(c.idx(index2));
    }

    @Override
    protected byte _getByte(int index2) {
        Component c = this.findComponent0(index2);
        return c.buf.getByte(c.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        Component c = this.findComponent0(index2);
        if (index2 + 2 <= c.endOffset) {
            return c.buf.getShort(c.idx(index2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(index2) & 0xFF) << 8 | this._getByte(index2 + 1) & 0xFF);
        }
        return (short)(this._getByte(index2) & 0xFF | (this._getByte(index2 + 1) & 0xFF) << 8);
    }

    @Override
    protected short _getShortLE(int index2) {
        Component c = this.findComponent0(index2);
        if (index2 + 2 <= c.endOffset) {
            return c.buf.getShortLE(c.idx(index2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(index2) & 0xFF | (this._getByte(index2 + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(index2) & 0xFF) << 8 | this._getByte(index2 + 1) & 0xFF);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        Component c = this.findComponent0(index2);
        if (index2 + 3 <= c.endOffset) {
            return c.buf.getUnsignedMedium(c.idx(index2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(index2) & 0xFFFF) << 8 | this._getByte(index2 + 2) & 0xFF;
        }
        return this._getShort(index2) & 0xFFFF | (this._getByte(index2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        Component c = this.findComponent0(index2);
        if (index2 + 3 <= c.endOffset) {
            return c.buf.getUnsignedMediumLE(c.idx(index2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(index2) & 0xFFFF | (this._getByte(index2 + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(index2) & 0xFFFF) << 8 | this._getByte(index2 + 2) & 0xFF;
    }

    @Override
    protected int _getInt(int index2) {
        Component c = this.findComponent0(index2);
        if (index2 + 4 <= c.endOffset) {
            return c.buf.getInt(c.idx(index2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(index2) & 0xFFFF) << 16 | this._getShort(index2 + 2) & 0xFFFF;
        }
        return this._getShort(index2) & 0xFFFF | (this._getShort(index2 + 2) & 0xFFFF) << 16;
    }

    @Override
    protected int _getIntLE(int index2) {
        Component c = this.findComponent0(index2);
        if (index2 + 4 <= c.endOffset) {
            return c.buf.getIntLE(c.idx(index2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(index2) & 0xFFFF | (this._getShortLE(index2 + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(index2) & 0xFFFF) << 16 | this._getShortLE(index2 + 2) & 0xFFFF;
    }

    @Override
    protected long _getLong(int index2) {
        Component c = this.findComponent0(index2);
        if (index2 + 8 <= c.endOffset) {
            return c.buf.getLong(c.idx(index2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(index2) & 0xFFFFFFFFL) << 32 | (long)this._getInt(index2 + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(index2) & 0xFFFFFFFFL | ((long)this._getInt(index2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    protected long _getLongLE(int index2) {
        Component c = this.findComponent0(index2);
        if (index2 + 8 <= c.endOffset) {
            return c.buf.getLongLE(c.idx(index2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(index2) & 0xFFFFFFFFL | ((long)this._getIntLE(index2 + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(index2) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE(index2 + 4) & 0xFFFFFFFFL;
    }

    @Override
    public CompositeByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.length);
        if (length2 == 0) {
            return this;
        }
        int i2 = this.toComponentIndex0(index2);
        while (length2 > 0) {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            c.buf.getBytes(c.idx(index2), dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeByteBuf getBytes(int index2, ByteBuffer dst) {
        int limit2 = dst.limit();
        int length2 = dst.remaining();
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return this;
        }
        int i2 = this.toComponentIndex0(index2);
        try {
            while (length2 > 0) {
                Component c = this.components[i2];
                int localLength = Math.min(length2, c.endOffset - index2);
                dst.limit(dst.position() + localLength);
                c.buf.getBytes(c.idx(index2), dst);
                index2 += localLength;
                length2 -= localLength;
                ++i2;
            }
        }
        finally {
            dst.limit(limit2);
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.capacity());
        if (length2 == 0) {
            return this;
        }
        int i2 = this.toComponentIndex0(index2);
        while (length2 > 0) {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            c.buf.getBytes(c.idx(index2), dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        int count2 = this.nioBufferCount();
        if (count2 == 1) {
            return out.write(this.internalNioBuffer(index2, length2));
        }
        long writtenBytes = out.write(this.nioBuffers(index2, length2));
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length2) throws IOException {
        int count2 = this.nioBufferCount();
        if (count2 == 1) {
            return out.write(this.internalNioBuffer(index2, length2), position);
        }
        long writtenBytes = 0L;
        for (ByteBuffer buf : this.nioBuffers(index2, length2)) {
            writtenBytes += (long)out.write(buf, position + writtenBytes);
        }
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    @Override
    public CompositeByteBuf getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return this;
        }
        int i2 = this.toComponentIndex0(index2);
        while (length2 > 0) {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            c.buf.getBytes(c.idx(index2), out, localLength);
            index2 += localLength;
            length2 -= localLength;
            ++i2;
        }
        return this;
    }

    @Override
    public CompositeByteBuf setByte(int index2, int value2) {
        Component c = this.findComponent(index2);
        c.buf.setByte(c.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        Component c = this.findComponent0(index2);
        c.buf.setByte(c.idx(index2), value2);
    }

    @Override
    public CompositeByteBuf setShort(int index2, int value2) {
        this.checkIndex(index2, 2);
        this._setShort(index2, value2);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value2) {
        Component c = this.findComponent0(index2);
        if (index2 + 2 <= c.endOffset) {
            c.buf.setShort(c.idx(index2), value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(index2, (byte)(value2 >>> 8));
            this._setByte(index2 + 1, (byte)value2);
        } else {
            this._setByte(index2, (byte)value2);
            this._setByte(index2 + 1, (byte)(value2 >>> 8));
        }
    }

    @Override
    protected void _setShortLE(int index2, int value2) {
        Component c = this.findComponent0(index2);
        if (index2 + 2 <= c.endOffset) {
            c.buf.setShortLE(c.idx(index2), value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(index2, (byte)value2);
            this._setByte(index2 + 1, (byte)(value2 >>> 8));
        } else {
            this._setByte(index2, (byte)(value2 >>> 8));
            this._setByte(index2 + 1, (byte)value2);
        }
    }

    @Override
    public CompositeByteBuf setMedium(int index2, int value2) {
        this.checkIndex(index2, 3);
        this._setMedium(index2, value2);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        Component c = this.findComponent0(index2);
        if (index2 + 3 <= c.endOffset) {
            c.buf.setMedium(c.idx(index2), value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(index2, (short)(value2 >> 8));
            this._setByte(index2 + 2, (byte)value2);
        } else {
            this._setShort(index2, (short)value2);
            this._setByte(index2 + 2, (byte)(value2 >>> 16));
        }
    }

    @Override
    protected void _setMediumLE(int index2, int value2) {
        Component c = this.findComponent0(index2);
        if (index2 + 3 <= c.endOffset) {
            c.buf.setMediumLE(c.idx(index2), value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(index2, (short)value2);
            this._setByte(index2 + 2, (byte)(value2 >>> 16));
        } else {
            this._setShortLE(index2, (short)(value2 >> 8));
            this._setByte(index2 + 2, (byte)value2);
        }
    }

    @Override
    public CompositeByteBuf setInt(int index2, int value2) {
        this.checkIndex(index2, 4);
        this._setInt(index2, value2);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value2) {
        Component c = this.findComponent0(index2);
        if (index2 + 4 <= c.endOffset) {
            c.buf.setInt(c.idx(index2), value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(index2, (short)(value2 >>> 16));
            this._setShort(index2 + 2, (short)value2);
        } else {
            this._setShort(index2, (short)value2);
            this._setShort(index2 + 2, (short)(value2 >>> 16));
        }
    }

    @Override
    protected void _setIntLE(int index2, int value2) {
        Component c = this.findComponent0(index2);
        if (index2 + 4 <= c.endOffset) {
            c.buf.setIntLE(c.idx(index2), value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(index2, (short)value2);
            this._setShortLE(index2 + 2, (short)(value2 >>> 16));
        } else {
            this._setShortLE(index2, (short)(value2 >>> 16));
            this._setShortLE(index2 + 2, (short)value2);
        }
    }

    @Override
    public CompositeByteBuf setLong(int index2, long value2) {
        this.checkIndex(index2, 8);
        this._setLong(index2, value2);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value2) {
        Component c = this.findComponent0(index2);
        if (index2 + 8 <= c.endOffset) {
            c.buf.setLong(c.idx(index2), value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setInt(index2, (int)(value2 >>> 32));
            this._setInt(index2 + 4, (int)value2);
        } else {
            this._setInt(index2, (int)value2);
            this._setInt(index2 + 4, (int)(value2 >>> 32));
        }
    }

    @Override
    protected void _setLongLE(int index2, long value2) {
        Component c = this.findComponent0(index2);
        if (index2 + 8 <= c.endOffset) {
            c.buf.setLongLE(c.idx(index2), value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setIntLE(index2, (int)value2);
            this._setIntLE(index2 + 4, (int)(value2 >>> 32));
        } else {
            this._setIntLE(index2, (int)(value2 >>> 32));
            this._setIntLE(index2 + 4, (int)value2);
        }
    }

    @Override
    public CompositeByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.length);
        if (length2 == 0) {
            return this;
        }
        int i2 = this.toComponentIndex0(index2);
        while (length2 > 0) {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            c.buf.setBytes(c.idx(index2), src, srcIndex, localLength);
            index2 += localLength;
            srcIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeByteBuf setBytes(int index2, ByteBuffer src) {
        int limit2 = src.limit();
        int length2 = src.remaining();
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return this;
        }
        int i2 = this.toComponentIndex0(index2);
        try {
            while (length2 > 0) {
                Component c = this.components[i2];
                int localLength = Math.min(length2, c.endOffset - index2);
                src.limit(src.position() + localLength);
                c.buf.setBytes(c.idx(index2), src);
                index2 += localLength;
                length2 -= localLength;
                ++i2;
            }
        }
        finally {
            src.limit(limit2);
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.capacity());
        if (length2 == 0) {
            return this;
        }
        int i2 = this.toComponentIndex0(index2);
        while (length2 > 0) {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            c.buf.setBytes(c.idx(index2), src, srcIndex, localLength);
            index2 += localLength;
            srcIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
        return this;
    }

    @Override
    public int setBytes(int index2, InputStream in, int length2) throws IOException {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return in.read(EmptyArrays.EMPTY_BYTES);
        }
        int i2 = this.toComponentIndex0(index2);
        int readBytes = 0;
        do {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            if (localLength == 0) {
                ++i2;
                continue;
            }
            int localReadBytes = c.buf.setBytes(c.idx(index2), in, localLength);
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            index2 += localReadBytes;
            length2 -= localReadBytes;
            readBytes += localReadBytes;
            if (localReadBytes != localLength) continue;
            ++i2;
        } while (length2 > 0);
        return readBytes;
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length2) throws IOException {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return in.read(EMPTY_NIO_BUFFER);
        }
        int i2 = this.toComponentIndex0(index2);
        int readBytes = 0;
        do {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            if (localLength == 0) {
                ++i2;
                continue;
            }
            int localReadBytes = c.buf.setBytes(c.idx(index2), in, localLength);
            if (localReadBytes == 0) break;
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            index2 += localReadBytes;
            length2 -= localReadBytes;
            readBytes += localReadBytes;
            if (localReadBytes != localLength) continue;
            ++i2;
        } while (length2 > 0);
        return readBytes;
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length2) throws IOException {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return in.read(EMPTY_NIO_BUFFER, position);
        }
        int i2 = this.toComponentIndex0(index2);
        int readBytes = 0;
        do {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            if (localLength == 0) {
                ++i2;
                continue;
            }
            int localReadBytes = c.buf.setBytes(c.idx(index2), in, position + (long)readBytes, localLength);
            if (localReadBytes == 0) break;
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            index2 += localReadBytes;
            length2 -= localReadBytes;
            readBytes += localReadBytes;
            if (localReadBytes != localLength) continue;
            ++i2;
        } while (length2 > 0);
        return readBytes;
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        this.checkIndex(index2, length2);
        ByteBuf dst = this.allocBuffer(length2);
        if (length2 != 0) {
            this.copyTo(index2, length2, this.toComponentIndex0(index2), dst);
        }
        return dst;
    }

    private void copyTo(int index2, int length2, int componentId, ByteBuf dst) {
        int dstIndex = 0;
        int i2 = componentId;
        while (length2 > 0) {
            Component c = this.components[i2];
            int localLength = Math.min(length2, c.endOffset - index2);
            c.buf.getBytes(c.idx(index2), dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
        dst.writerIndex(dst.capacity());
    }

    public ByteBuf component(int cIndex) {
        this.checkComponentIndex(cIndex);
        return this.components[cIndex].duplicate();
    }

    public ByteBuf componentAtOffset(int offset2) {
        return this.findComponent(offset2).duplicate();
    }

    public ByteBuf internalComponent(int cIndex) {
        this.checkComponentIndex(cIndex);
        return this.components[cIndex].slice();
    }

    public ByteBuf internalComponentAtOffset(int offset2) {
        return this.findComponent(offset2).slice();
    }

    private Component findComponent(int offset2) {
        Component la = this.lastAccessed;
        if (la != null && offset2 >= la.offset && offset2 < la.endOffset) {
            this.ensureAccessible();
            return la;
        }
        this.checkIndex(offset2);
        return this.findIt(offset2);
    }

    private Component findComponent0(int offset2) {
        Component la = this.lastAccessed;
        if (la != null && offset2 >= la.offset && offset2 < la.endOffset) {
            return la;
        }
        return this.findIt(offset2);
    }

    private Component findIt(int offset2) {
        int low = 0;
        int high = this.componentCount;
        while (low <= high) {
            int mid = low + high >>> 1;
            Component c = this.components[mid];
            if (offset2 >= c.endOffset) {
                low = mid + 1;
                continue;
            }
            if (offset2 < c.offset) {
                high = mid - 1;
                continue;
            }
            this.lastAccessed = c;
            return c;
        }
        throw new Error("should not reach here");
    }

    @Override
    public int nioBufferCount() {
        int size2 = this.componentCount;
        switch (size2) {
            case 0: {
                return 1;
            }
            case 1: {
                return this.components[0].buf.nioBufferCount();
            }
        }
        int count2 = 0;
        for (int i2 = 0; i2 < size2; ++i2) {
            count2 += this.components[i2].buf.nioBufferCount();
        }
        return count2;
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length2) {
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                return this.components[0].internalNioBuffer(index2, length2);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                Component c = this.components[0];
                ByteBuf buf = c.buf;
                if (buf.nioBufferCount() != 1) break;
                return buf.nioBuffer(c.idx(index2), length2);
            }
        }
        ByteBuffer[] buffers = this.nioBuffers(index2, length2);
        if (buffers.length == 1) {
            return buffers[0];
        }
        ByteBuffer merged = ByteBuffer.allocate(length2).order(this.order());
        for (ByteBuffer buf : buffers) {
            merged.put(buf);
        }
        merged.flip();
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] nioBuffers(int index2, int length2) {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return new ByteBuffer[]{EMPTY_NIO_BUFFER};
        }
        RecyclableArrayList buffers = RecyclableArrayList.newInstance(this.componentCount);
        try {
            int i2 = this.toComponentIndex0(index2);
            while (length2 > 0) {
                Component c = this.components[i2];
                ByteBuf s2 = c.buf;
                int localLength = Math.min(length2, c.endOffset - index2);
                switch (s2.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        buffers.add(s2.nioBuffer(c.idx(index2), localLength));
                        break;
                    }
                    default: {
                        Collections.addAll(buffers, s2.nioBuffers(c.idx(index2), localLength));
                    }
                }
                index2 += localLength;
                length2 -= localLength;
                ++i2;
            }
            ByteBuffer[] byteBufferArray = buffers.toArray(new ByteBuffer[0]);
            return byteBufferArray;
        }
        finally {
            buffers.recycle();
        }
    }

    public CompositeByteBuf consolidate() {
        this.ensureAccessible();
        this.consolidate0(0, this.componentCount);
        return this;
    }

    public CompositeByteBuf consolidate(int cIndex, int numComponents) {
        this.checkComponentIndex(cIndex, numComponents);
        this.consolidate0(cIndex, numComponents);
        return this;
    }

    private void consolidate0(int cIndex, int numComponents) {
        if (numComponents <= 1) {
            return;
        }
        int endCIndex = cIndex + numComponents;
        int startOffset = cIndex != 0 ? this.components[cIndex].offset : 0;
        int capacity = this.components[endCIndex - 1].endOffset - startOffset;
        ByteBuf consolidated = this.allocBuffer(capacity);
        for (int i2 = cIndex; i2 < endCIndex; ++i2) {
            this.components[i2].transferTo(consolidated);
        }
        this.lastAccessed = null;
        this.removeCompRange(cIndex + 1, endCIndex);
        this.components[cIndex] = this.newComponent(consolidated, 0);
        if (cIndex != 0 || numComponents != this.componentCount) {
            this.updateComponentOffsets(cIndex);
        }
    }

    public CompositeByteBuf discardReadComponents() {
        int firstComponentId;
        this.ensureAccessible();
        int readerIndex = this.readerIndex();
        if (readerIndex == 0) {
            return this;
        }
        int writerIndex = this.writerIndex();
        if (readerIndex == writerIndex && writerIndex == this.capacity()) {
            int size2 = this.componentCount;
            for (int i2 = 0; i2 < size2; ++i2) {
                this.components[i2].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(readerIndex);
            return this;
        }
        Component c = null;
        int size3 = this.componentCount;
        for (firstComponentId = 0; firstComponentId < size3; ++firstComponentId) {
            c = this.components[firstComponentId];
            if (c.endOffset > readerIndex) break;
            c.free();
        }
        if (firstComponentId == 0) {
            return this;
        }
        Component la = this.lastAccessed;
        if (la != null && la.endOffset <= readerIndex) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, firstComponentId);
        int offset2 = c.offset;
        this.updateComponentOffsets(0);
        this.setIndex(readerIndex - offset2, writerIndex - offset2);
        this.adjustMarkers(offset2);
        return this;
    }

    @Override
    public CompositeByteBuf discardReadBytes() {
        Component la;
        int firstComponentId;
        this.ensureAccessible();
        int readerIndex = this.readerIndex();
        if (readerIndex == 0) {
            return this;
        }
        int writerIndex = this.writerIndex();
        if (readerIndex == writerIndex && writerIndex == this.capacity()) {
            int size2 = this.componentCount;
            for (int i2 = 0; i2 < size2; ++i2) {
                this.components[i2].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(readerIndex);
            return this;
        }
        Component c = null;
        int size3 = this.componentCount;
        for (firstComponentId = 0; firstComponentId < size3; ++firstComponentId) {
            c = this.components[firstComponentId];
            if (c.endOffset > readerIndex) break;
            c.free();
        }
        int trimmedBytes = readerIndex - c.offset;
        c.offset = 0;
        c.endOffset -= readerIndex;
        c.srcAdjustment += readerIndex;
        c.adjustment += readerIndex;
        ByteBuf slice = c.slice;
        if (slice != null) {
            c.slice = slice.slice(trimmedBytes, c.length());
        }
        if ((la = this.lastAccessed) != null && la.endOffset <= readerIndex) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, firstComponentId);
        this.updateComponentOffsets(0);
        this.setIndex(0, writerIndex - readerIndex);
        this.adjustMarkers(readerIndex);
        return this;
    }

    private ByteBuf allocBuffer(int capacity) {
        return this.direct ? this.alloc().directBuffer(capacity) : this.alloc().heapBuffer(capacity);
    }

    @Override
    public String toString() {
        String result2 = super.toString();
        result2 = result2.substring(0, result2.length() - 1);
        return result2 + ", components=" + this.componentCount + ')';
    }

    @Override
    public CompositeByteBuf readerIndex(int readerIndex) {
        super.readerIndex(readerIndex);
        return this;
    }

    @Override
    public CompositeByteBuf writerIndex(int writerIndex) {
        super.writerIndex(writerIndex);
        return this;
    }

    @Override
    public CompositeByteBuf setIndex(int readerIndex, int writerIndex) {
        super.setIndex(readerIndex, writerIndex);
        return this;
    }

    @Override
    public CompositeByteBuf clear() {
        super.clear();
        return this;
    }

    @Override
    public CompositeByteBuf markReaderIndex() {
        super.markReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetReaderIndex() {
        super.resetReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf markWriterIndex() {
        super.markWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetWriterIndex() {
        super.resetWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf ensureWritable(int minWritableBytes) {
        super.ensureWritable(minWritableBytes);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int index2, ByteBuf dst) {
        return this.getBytes(index2, dst, dst.writableBytes());
    }

    @Override
    public CompositeByteBuf getBytes(int index2, ByteBuf dst, int length2) {
        this.getBytes(index2, dst, dst.writerIndex(), length2);
        dst.writerIndex(dst.writerIndex() + length2);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int index2, byte[] dst) {
        return this.getBytes(index2, dst, 0, dst.length);
    }

    @Override
    public CompositeByteBuf setBoolean(int index2, boolean value2) {
        return this.setByte(index2, value2 ? 1 : 0);
    }

    @Override
    public CompositeByteBuf setChar(int index2, int value2) {
        return this.setShort(index2, value2);
    }

    @Override
    public CompositeByteBuf setFloat(int index2, float value2) {
        return this.setInt(index2, Float.floatToRawIntBits(value2));
    }

    @Override
    public CompositeByteBuf setDouble(int index2, double value2) {
        return this.setLong(index2, Double.doubleToRawLongBits(value2));
    }

    @Override
    public CompositeByteBuf setBytes(int index2, ByteBuf src) {
        super.setBytes(index2, src, src.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int index2, ByteBuf src, int length2) {
        super.setBytes(index2, src, length2);
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int index2, byte[] src) {
        return this.setBytes(index2, src, 0, src.length);
    }

    @Override
    public CompositeByteBuf setZero(int index2, int length2) {
        super.setZero(index2, length2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf dst) {
        super.readBytes(dst, dst.writableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf dst, int length2) {
        super.readBytes(dst, length2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf dst, int dstIndex, int length2) {
        super.readBytes(dst, dstIndex, length2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] dst) {
        super.readBytes(dst, 0, dst.length);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] dst, int dstIndex, int length2) {
        super.readBytes(dst, dstIndex, length2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuffer dst) {
        super.readBytes(dst);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(OutputStream out, int length2) throws IOException {
        super.readBytes(out, length2);
        return this;
    }

    @Override
    public CompositeByteBuf skipBytes(int length2) {
        super.skipBytes(length2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBoolean(boolean value2) {
        this.writeByte(value2 ? 1 : 0);
        return this;
    }

    @Override
    public CompositeByteBuf writeByte(int value2) {
        this.ensureWritable0(1);
        this._setByte(this.writerIndex++, value2);
        return this;
    }

    @Override
    public CompositeByteBuf writeShort(int value2) {
        super.writeShort(value2);
        return this;
    }

    @Override
    public CompositeByteBuf writeMedium(int value2) {
        super.writeMedium(value2);
        return this;
    }

    @Override
    public CompositeByteBuf writeInt(int value2) {
        super.writeInt(value2);
        return this;
    }

    @Override
    public CompositeByteBuf writeLong(long value2) {
        super.writeLong(value2);
        return this;
    }

    @Override
    public CompositeByteBuf writeChar(int value2) {
        super.writeShort(value2);
        return this;
    }

    @Override
    public CompositeByteBuf writeFloat(float value2) {
        super.writeInt(Float.floatToRawIntBits(value2));
        return this;
    }

    @Override
    public CompositeByteBuf writeDouble(double value2) {
        super.writeLong(Double.doubleToRawLongBits(value2));
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf src) {
        super.writeBytes(src, src.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf src, int length2) {
        super.writeBytes(src, length2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf src, int srcIndex, int length2) {
        super.writeBytes(src, srcIndex, length2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] src) {
        super.writeBytes(src, 0, src.length);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] src, int srcIndex, int length2) {
        super.writeBytes(src, srcIndex, length2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuffer src) {
        super.writeBytes(src);
        return this;
    }

    @Override
    public CompositeByteBuf writeZero(int length2) {
        super.writeZero(length2);
        return this;
    }

    @Override
    public CompositeByteBuf retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public CompositeByteBuf retain() {
        super.retain();
        return this;
    }

    @Override
    public CompositeByteBuf touch() {
        return this;
    }

    @Override
    public CompositeByteBuf touch(Object hint) {
        return this;
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex(), this.readableBytes());
    }

    @Override
    public CompositeByteBuf discardSomeReadBytes() {
        return this.discardReadComponents();
    }

    @Override
    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        int size2 = this.componentCount;
        for (int i2 = 0; i2 < size2; ++i2) {
            this.components[i2].free();
        }
    }

    @Override
    boolean isAccessible() {
        return !this.freed;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    private void clearComps() {
        this.removeCompRange(0, this.componentCount);
    }

    private void removeComp(int i2) {
        this.removeCompRange(i2, i2 + 1);
    }

    private void removeCompRange(int from, int to) {
        int newSize;
        if (from >= to) {
            return;
        }
        int size2 = this.componentCount;
        assert (from >= 0 && to <= size2);
        if (to < size2) {
            System.arraycopy(this.components, to, this.components, from, size2 - to);
        }
        for (int i2 = newSize = size2 - to + from; i2 < size2; ++i2) {
            this.components[i2] = null;
        }
        this.componentCount = newSize;
    }

    private void addComp(int i2, Component c) {
        this.shiftComps(i2, 1);
        this.components[i2] = c;
    }

    private void shiftComps(int i2, int count2) {
        int size2 = this.componentCount;
        int newSize = size2 + count2;
        assert (i2 >= 0 && i2 <= size2 && count2 > 0);
        if (newSize > this.components.length) {
            Component[] newArr;
            int newArrSize = Math.max(size2 + (size2 >> 1), newSize);
            if (i2 == size2) {
                newArr = (Component[])Arrays.copyOf(this.components, newArrSize, Component[].class);
            } else {
                newArr = new Component[newArrSize];
                if (i2 > 0) {
                    System.arraycopy(this.components, 0, newArr, 0, i2);
                }
                if (i2 < size2) {
                    System.arraycopy(this.components, i2, newArr, i2 + count2, size2 - i2);
                }
            }
            this.components = newArr;
        } else if (i2 < size2) {
            System.arraycopy(this.components, i2, this.components, i2 + count2, size2 - i2);
        }
        this.componentCount = newSize;
    }

    private final class CompositeByteBufIterator
    implements Iterator<ByteBuf> {
        private final int size;
        private int index;

        private CompositeByteBufIterator() {
            this.size = CompositeByteBuf.this.numComponents();
        }

        @Override
        public boolean hasNext() {
            return this.size > this.index;
        }

        @Override
        public ByteBuf next() {
            if (this.size != CompositeByteBuf.this.numComponents()) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return CompositeByteBuf.this.components[this.index++].slice();
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-Only");
        }
    }

    private static final class Component {
        final ByteBuf srcBuf;
        final ByteBuf buf;
        int srcAdjustment;
        int adjustment;
        int offset;
        int endOffset;
        private ByteBuf slice;

        Component(ByteBuf srcBuf, int srcOffset, ByteBuf buf, int bufOffset, int offset2, int len, ByteBuf slice) {
            this.srcBuf = srcBuf;
            this.srcAdjustment = srcOffset - offset2;
            this.buf = buf;
            this.adjustment = bufOffset - offset2;
            this.offset = offset2;
            this.endOffset = offset2 + len;
            this.slice = slice;
        }

        int srcIdx(int index2) {
            return index2 + this.srcAdjustment;
        }

        int idx(int index2) {
            return index2 + this.adjustment;
        }

        int length() {
            return this.endOffset - this.offset;
        }

        void reposition(int newOffset) {
            int move = newOffset - this.offset;
            this.endOffset += move;
            this.srcAdjustment -= move;
            this.adjustment -= move;
            this.offset = newOffset;
        }

        void transferTo(ByteBuf dst) {
            dst.writeBytes(this.buf, this.idx(this.offset), this.length());
            this.free();
        }

        ByteBuf slice() {
            ByteBuf s2 = this.slice;
            if (s2 == null) {
                this.slice = s2 = this.srcBuf.slice(this.srcIdx(this.offset), this.length());
            }
            return s2;
        }

        ByteBuf duplicate() {
            return this.srcBuf.duplicate();
        }

        ByteBuffer internalNioBuffer(int index2, int length2) {
            return this.srcBuf.internalNioBuffer(this.srcIdx(index2), length2);
        }

        void free() {
            this.slice = null;
            this.srcBuf.release();
        }
    }

    static interface ByteWrapper<T> {
        public ByteBuf wrap(T var1);

        public boolean isEmpty(T var1);
    }
}

