/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.session.SessionId;
import java.util.Objects;

public final class SessionMetadata {
    private final long id;
    private final String name;
    private final String type;

    public SessionMetadata(long id, String name, String type) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
    }

    public SessionId sessionId() {
        return SessionId.from(this.id);
    }

    public String primitiveName() {
        return this.name;
    }

    public String primitiveType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.name);
    }

    public boolean equals(Object object) {
        if (object instanceof SessionMetadata) {
            SessionMetadata metadata = (SessionMetadata)object;
            return metadata.id == this.id && Objects.equals(metadata.name, this.name) && Objects.equals(metadata.type, this.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }
}

