/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm;

import java.util.LinkedHashSet;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.zeppelin.realm.UserPrincipal;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;

public class PamRealm
extends AuthorizingRealm {
    private String service;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        LinkedHashSet roles = new LinkedHashSet();
        UserPrincipal user = (UserPrincipal)principals.oneByType(UserPrincipal.class);
        if (user != null) {
            roles.addAll(user.getUnixUser().getGroups());
        }
        return new SimpleAuthorizationInfo(roles);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UnixUser user;
        UsernamePasswordToken userToken = (UsernamePasswordToken)token;
        try {
            user = new PAM(this.getService()).authenticate(userToken.getUsername(), new String(userToken.getPassword()));
        }
        catch (PAMException e) {
            throw new AuthenticationException("Authentication failed for PAM.", (Throwable)e);
        }
        return new SimpleAuthenticationInfo((Object)new UserPrincipal(user), userToken.getCredentials(), this.getName());
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }
}

