/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.DefaultLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapGroupRealm
extends DefaultLdapRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapGroupRealm.class);

    public AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext ldapContext = ldapContextFactory.getSystemLdapContext();
        Set<String> roleNames = this.getRoleNamesForUser(username, ldapContext, this.getUserDnTemplate());
        return new SimpleAuthorizationInfo(roleNames);
    }

    public Set<String> getRoleNamesForUser(String username, LdapContext ldapContext, String userDnTemplate) {
        try {
            LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String searchFilter = "(&(objectClass=groupOfNames)(member=" + userDnTemplate + "))";
            Object[] searchArguments = new Object[]{username};
            NamingEnumeration<SearchResult> answer = ldapContext.search(String.valueOf(ldapContext.getEnvironment().get("ldap.searchBase")), searchFilter, searchArguments, searchCtls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                if (attrs == null) continue;
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    if (!attr.getID().equals("cn")) continue;
                    roleNames.add((String)attr.get());
                }
            }
            return roleNames;
        }
        catch (Exception e) {
            LOGGER.error("Error", (Throwable)e);
            return new HashSet<String>();
        }
    }
}

