/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.formatters;

import com.ibm.icu.impl.number.Format;
import com.ibm.icu.impl.number.FormatQuantity;
import com.ibm.icu.impl.number.ModifierHolder;
import com.ibm.icu.impl.number.NumberStringBuilder;
import java.util.Deque;

public class RangeFormat
extends Format {
    private final String separator;
    private final Format left;
    private final Format right;

    public RangeFormat(Format left, Format right, String separator) {
        this.separator = separator;
        this.left = left;
        this.right = right;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Both child formatters are required for RangeFormat");
        }
    }

    @Override
    public int process(Deque<FormatQuantity> inputs, ModifierHolder mods, NumberStringBuilder string, int startIndex) {
        ModifierHolder lMods = new ModifierHolder();
        ModifierHolder rMods = new ModifierHolder();
        int lLen = this.left.process(inputs, lMods, string, startIndex);
        int rLen = this.right.process(inputs, rMods, string, startIndex + lLen);
        while (lMods.peekLast() != null && lMods.peekLast() == rMods.peekLast()) {
            mods.add(lMods.removeLast());
            rMods.removeLast();
        }
        lLen += lMods.applyAll(string, startIndex, startIndex + lLen);
        rLen += rMods.applyAll(string, startIndex + lLen, startIndex + lLen + rLen);
        int sLen = string.insert(startIndex + lLen, this.separator, null);
        return lLen + sLen + rLen;
    }
}

