/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.Objects;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ValueAdapter;
import org.neo4j.driver.types.Type;

public class StringValue
extends ValueAdapter {
    private final String val;

    public StringValue(String val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot construct StringValue from null");
        }
        this.val = val;
    }

    @Override
    public boolean isEmpty() {
        return this.val.isEmpty();
    }

    @Override
    public int size() {
        return this.val.length();
    }

    @Override
    public String asObject() {
        return this.asString();
    }

    @Override
    public String asString() {
        return this.val;
    }

    @Override
    public String toString() {
        return String.format("\"%s\"", this.val.replace("\"", "\\\""));
    }

    @Override
    public Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.STRING();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue that = (StringValue)o;
        return Objects.equals(this.val, that.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }
}

