/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.hubspot.jinjava.el.ext.AbsOperator;
import com.hubspot.jinjava.el.ext.ExtendedParser;
import com.hubspot.jinjava.el.ext.NamedParameterOperator;
import com.hubspot.jinjava.el.ext.StringConcatOperator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jinjava.de.odysseus.el.tree.impl.Scanner;

public class ExtendedScanner
extends Scanner {
    private static final Method ADD_KEY_TOKEN_METHOD;
    private static final Field TOKEN_FIELD;
    private static final Field POSITION_FIELD;

    protected ExtendedScanner(String input) {
        super(input);
    }

    @Override
    public Scanner.Token next() throws Scanner.ScanException {
        if (this.getToken() != null) {
            this.incrPosition(this.getToken().getSize());
        }
        int length = this.getInput().length();
        if (this.isEval()) {
            while (this.getPosition() < length && this.isWhitespace(this.getInput().charAt(this.getPosition()))) {
                this.incrPosition(1);
            }
        }
        Scanner.Token token = null;
        token = this.getPosition() == length ? this.fixed(Scanner.Symbol.EOF) : this.nextToken();
        this.setToken(token);
        return token;
    }

    protected boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    protected static void addKeyToken(Scanner.Token token) {
        try {
            ADD_KEY_TOKEN_METHOD.invoke(null, token);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setToken(Scanner.Token token) {
        try {
            TOKEN_FIELD.set(this, token);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    protected void incrPosition(int n) {
        try {
            POSITION_FIELD.set(this, this.getPosition() + n);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Scanner.Token nextToken() throws Scanner.ScanException {
        if (this.isEval()) {
            if (this.getInput().charAt(this.getPosition()) == '}') {
                if (this.getPosition() < this.getInput().length() - 1) {
                    return ExtendedParser.LITERAL_DICT_END;
                }
                return this.fixed(Scanner.Symbol.END_EVAL);
            }
            return this.nextEval();
        }
        if (this.getPosition() + 1 < this.getInput().length() && this.getInput().charAt(this.getPosition() + 1) == '{') {
            switch (this.getInput().charAt(this.getPosition())) {
                case '#': {
                    return this.fixed(Scanner.Symbol.START_EVAL_DEFERRED);
                }
                case '$': {
                    return this.fixed(Scanner.Symbol.START_EVAL_DYNAMIC);
                }
            }
            return this.nextText();
        }
        return this.nextText();
    }

    @Override
    protected Scanner.Token nextEval() throws Scanner.ScanException {
        char c2;
        char c1 = this.getInput().charAt(this.getPosition());
        char c = c2 = this.getPosition() < this.getInput().length() - 1 ? this.getInput().charAt(this.getPosition() + 1) : (char)'\u0000';
        if (c1 == '/' && c2 == '/') {
            return ExtendedParser.TRUNC_DIV;
        }
        if (c1 == '*' && c2 == '*') {
            return ExtendedParser.POWER_OF;
        }
        if (c1 == '|' && c2 != '|') {
            return ExtendedParser.PIPE;
        }
        if (c1 == '+' && Character.isDigit(c2)) {
            return AbsOperator.TOKEN;
        }
        if (c1 == '=' && c2 != '=') {
            return NamedParameterOperator.TOKEN;
        }
        if (c1 == '{') {
            return ExtendedParser.LITERAL_DICT_START;
        }
        if (c1 == '}' && c2 != '\u0000') {
            return ExtendedParser.LITERAL_DICT_END;
        }
        if (c1 == '~') {
            return StringConcatOperator.TOKEN;
        }
        return super.nextEval();
    }

    @Override
    protected Scanner.Token nextString() throws Scanner.ScanException {
        this.builder.setLength(0);
        char quote = this.getInput().charAt(this.getPosition());
        int i = this.getPosition() + 1;
        int l = this.getInput().length();
        block8: while (i < l) {
            char c = this.getInput().charAt(i++);
            if (c == '\\') {
                if (i == l) {
                    throw new Scanner.ScanException(this.getPosition(), "unterminated string", quote + " or \\");
                }
                c = this.getInput().charAt(i++);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        this.builder.append(c);
                        continue block8;
                    }
                    case 'n': {
                        this.builder.append('\n');
                        continue block8;
                    }
                    case 't': {
                        this.builder.append('\t');
                        continue block8;
                    }
                    case 'b': {
                        this.builder.append('\b');
                        continue block8;
                    }
                    case 'f': {
                        this.builder.append('\f');
                        continue block8;
                    }
                    case 'r': {
                        this.builder.append('\r');
                        continue block8;
                    }
                }
                throw new Scanner.ScanException(this.getPosition(), "invalid escape sequence \\" + c, "\\" + quote + " or \\\\");
            }
            if (c == quote) {
                return this.token(Scanner.Symbol.STRING, this.builder.toString(), i - this.getPosition());
            }
            this.builder.append(c);
        }
        throw new Scanner.ScanException(this.getPosition(), "unterminated string", String.valueOf(quote));
    }

    static {
        try {
            ADD_KEY_TOKEN_METHOD = Scanner.class.getDeclaredMethod("addKeyToken", Scanner.Token.class);
            ADD_KEY_TOKEN_METHOD.setAccessible(true);
            TOKEN_FIELD = Scanner.class.getDeclaredField("token");
            TOKEN_FIELD.setAccessible(true);
            POSITION_FIELD = Scanner.class.getDeclaredField("position");
            POSITION_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

