/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class CountingIterator<ElementT>
implements Iterator<ElementT> {
    protected int remaining;
    private State state = State.NOT_READY;
    private ElementT next;

    public CountingIterator(int remaining) {
        this.remaining = remaining;
    }

    public int remaining() {
        return this.remaining;
    }

    protected abstract ElementT computeNext();

    protected final ElementT endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final ElementT next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        ElementT result2 = this.next;
        this.next = null;
        --this.remaining;
        return result2;
    }

    public final ElementT peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

