/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedToken;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedTokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenRangeBase;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class ByteOrderedTokenRange
extends TokenRangeBase {
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    public ByteOrderedTokenRange(ByteOrderedToken start, ByteOrderedToken end) {
        super(start, end, ByteOrderedTokenFactory.MIN_TOKEN);
    }

    @Override
    protected TokenRange newTokenRange(Token start, Token end) {
        return new ByteOrderedTokenRange((ByteOrderedToken)start, (ByteOrderedToken)end);
    }

    @Override
    protected List<Token> split(Token rawStartToken, Token rawEndToken, int numberOfSplits) {
        BigInteger ringEnd;
        BigInteger ringLength;
        BigInteger range;
        BigInteger end;
        BigInteger start;
        int addedBytes;
        int significantBytes;
        int tokenOrder = rawStartToken.compareTo(rawEndToken);
        if (tokenOrder == 0 && rawStartToken.equals(ByteOrderedTokenFactory.MIN_TOKEN)) {
            throw new IllegalArgumentException("Cannot split whole ring with ordered partitioner");
        }
        ByteOrderedToken startToken = (ByteOrderedToken)rawStartToken;
        ByteOrderedToken endToken = (ByteOrderedToken)rawEndToken;
        BigInteger bigNumberOfSplits = BigInteger.valueOf(numberOfSplits);
        if (tokenOrder < 0) {
            significantBytes = Math.max(startToken.getValue().capacity(), endToken.getValue().capacity());
            addedBytes = 0;
            while (true) {
                start = this.toBigInteger(startToken.getValue(), significantBytes);
                end = this.toBigInteger(endToken.getValue(), significantBytes);
                range = end.subtract(start);
                if (addedBytes == 4 || start.equals(end) || range.compareTo(bigNumberOfSplits) >= 0) break;
                ++significantBytes;
                ++addedBytes;
            }
            ringLength = null;
            ringEnd = null;
        } else {
            significantBytes = Math.max(startToken.getValue().capacity(), endToken.getValue().capacity());
            addedBytes = 0;
            while (true) {
                start = this.toBigInteger(startToken.getValue(), significantBytes);
                end = this.toBigInteger(endToken.getValue(), significantBytes);
                ringLength = TWO.pow(significantBytes * 8);
                ringEnd = ringLength.subtract(BigInteger.ONE);
                range = end.subtract(start).add(ringLength);
                if (addedBytes == 4 || range.compareTo(bigNumberOfSplits) >= 0) break;
                ++significantBytes;
                ++addedBytes;
            }
        }
        List<BigInteger> values2 = super.split(start, range, ringEnd, ringLength, numberOfSplits);
        ArrayList<Token> tokens = Lists.newArrayListWithExpectedSize(values2.size());
        for (BigInteger value : values2) {
            tokens.add(new ByteOrderedToken(this.toBytes(value, significantBytes)));
        }
        return tokens;
    }

    private BigInteger toBigInteger(ByteBuffer bb, int significantBytes) {
        byte[] target;
        byte[] bytes = Bytes.getArray(bb);
        if (significantBytes != bytes.length) {
            target = new byte[significantBytes];
            System.arraycopy(bytes, 0, target, 0, bytes.length);
        } else {
            target = bytes;
        }
        return new BigInteger(1, target);
    }

    protected ByteBuffer toBytes(BigInteger value, int significantBytes) {
        byte[] result2;
        byte[] rawBytes = value.toByteArray();
        if (rawBytes.length == significantBytes) {
            result2 = rawBytes;
        } else {
            int length;
            int start;
            result2 = new byte[significantBytes];
            if (rawBytes[0] == 0) {
                start = 1;
                length = rawBytes.length - 1;
            } else {
                start = 0;
                length = rawBytes.length;
            }
            System.arraycopy(rawBytes, start, result2, significantBytes - length, length);
        }
        return ByteBuffer.wrap(result2);
    }
}

