/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

public class InboundTrafficMeter
extends ChannelInboundHandlerAdapter {
    private final NodeMetricUpdater nodeMetricUpdater;
    private final SessionMetricUpdater sessionMetricUpdater;

    InboundTrafficMeter(NodeMetricUpdater nodeMetricUpdater, SessionMetricUpdater sessionMetricUpdater) {
        this.nodeMetricUpdater = nodeMetricUpdater;
        this.sessionMetricUpdater = sessionMetricUpdater;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            int bytes = ((ByteBuf)msg).readableBytes();
            this.nodeMetricUpdater.markMeter(DefaultNodeMetric.BYTES_RECEIVED, null, bytes);
            this.sessionMetricUpdater.markMeter(DefaultSessionMetric.BYTES_RECEIVED, null, bytes);
        }
        super.channelRead(ctx, msg);
    }
}

