/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metrics;

import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;

public enum DefaultSessionMetric implements SessionMetric
{
    BYTES_SENT("bytes-sent"),
    BYTES_RECEIVED("bytes-received"),
    CONNECTED_NODES("connected-nodes"),
    CQL_REQUESTS("cql-requests"),
    CQL_CLIENT_TIMEOUTS("cql-client-timeouts"),
    THROTTLING_DELAY("throttling.delay"),
    THROTTLING_QUEUE_SIZE("throttling.queue-size"),
    THROTTLING_ERRORS("throttling.errors"),
    CQL_PREPARED_CACHE_SIZE("cql-prepared-cache-size");

    private static final Map<String, DefaultSessionMetric> BY_PATH;
    private final String path;

    private DefaultSessionMetric(String path) {
        this.path = path;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public static DefaultSessionMetric fromPath(@NonNull String path) {
        DefaultSessionMetric metric = BY_PATH.get(path);
        if (metric == null) {
            throw new IllegalArgumentException("Unknown session metric path " + path);
        }
        return metric;
    }

    private static Map<String, DefaultSessionMetric> sortByPath() {
        ImmutableMap.Builder<String, DefaultSessionMetric> result2 = ImmutableMap.builder();
        for (DefaultSessionMetric value : DefaultSessionMetric.values()) {
            result2.put(value.getPath(), value);
        }
        return result2.build();
    }

    static {
        BY_PATH = DefaultSessionMetric.sortByPath();
    }
}

