/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.impl.BlockingDistributedMap;
import io.atomix.core.multimap.AsyncDistributedMultimap;
import io.atomix.core.multimap.DistributedMultimap;
import io.atomix.core.multimap.MultimapEventListener;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.impl.BlockingDistributedMultiset;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class BlockingDistributedMultimap<K, V>
extends Synchronous<AsyncDistributedMultimap<K, V>>
implements DistributedMultimap<K, V> {
    private final AsyncDistributedMultimap<K, V> asyncMultimap;
    private final long operationTimeoutMillis;

    public BlockingDistributedMultimap(AsyncDistributedMultimap<K, V> asyncMultimap, long operationTimeoutMillis) {
        super(asyncMultimap);
        this.asyncMultimap = asyncMultimap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    public int size() {
        return this.complete(this.asyncMultimap.size());
    }

    public boolean isEmpty() {
        return this.complete(this.asyncMultimap.isEmpty());
    }

    public boolean containsKey(@Nullable Object key) {
        return this.complete(this.asyncMultimap.containsKey(key));
    }

    public boolean containsValue(@Nullable Object value) {
        return this.complete(this.asyncMultimap.containsValue(value));
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        return this.complete(this.asyncMultimap.containsEntry(key, value));
    }

    public boolean put(@Nullable K key, @Nullable V value) {
        return this.complete(this.asyncMultimap.put(key, value));
    }

    public boolean remove(@Nullable Object key, @Nullable Object value) {
        return this.complete(this.asyncMultimap.remove(key, value));
    }

    public boolean putAll(@Nullable K key, Iterable<? extends V> values) {
        return this.complete(this.asyncMultimap.putAll(key, values instanceof Collection ? (Collection)values : Lists.newArrayList(values)));
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        throw new UnsupportedOperationException();
    }

    public Collection<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        return this.complete(this.asyncMultimap.replaceValues(key, values instanceof Collection ? (Collection)values : Lists.newArrayList(values)));
    }

    public Collection<V> removeAll(@Nullable Object key) {
        return this.complete(this.asyncMultimap.removeAll(key));
    }

    public void clear() {
        this.complete(this.asyncMultimap.clear());
    }

    public Collection<V> get(@Nullable K key) {
        return this.complete(this.asyncMultimap.get(key));
    }

    @Override
    public DistributedSet<K> keySet() {
        return new BlockingDistributedSet<K>(this.asyncMultimap.keySet(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedMultiset<K> keys() {
        return new BlockingDistributedMultiset<K>(this.asyncMultimap.keys(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedMultiset<V> values() {
        return new BlockingDistributedMultiset<V>(this.asyncMultimap.values(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedCollection<Map.Entry<K, V>> entries() {
        return new BlockingDistributedCollection<Map.Entry<K, V>>(this.asyncMultimap.entries(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedMap<K, Collection<V>> asMap() {
        return new BlockingDistributedMap<K, Collection<V>>(this.asyncMultimap.asMap(), this.operationTimeoutMillis);
    }

    @Override
    public void addListener(MultimapEventListener<K, V> listener, Executor executor) {
        this.complete(this.asyncMultimap.addListener(listener, executor));
    }

    @Override
    public void removeListener(MultimapEventListener<K, V> listener) {
        this.complete(this.asyncMultimap.removeListener(listener));
    }

    @Override
    public AsyncDistributedMultimap<K, V> async() {
        return this.asyncMultimap;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new PrimitiveException(e.getCause());
        }
    }
}

