/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.cache.CacheConfig;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.impl.DelegatingAsyncDistributedCollection;
import io.atomix.primitive.PrimitiveState;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingAsyncDistributedCollection<E>
extends DelegatingAsyncDistributedCollection<E> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final LoadingCache<E, CompletableFuture<Boolean>> cache;
    private final CollectionEventListener<E> cacheUpdater;
    private final Consumer<PrimitiveState> statusListener;
    private final Map<CollectionEventListener<E>, Executor> eventListeners = new ConcurrentHashMap<CollectionEventListener<E>, Executor>();

    public CachingAsyncDistributedCollection(AsyncDistributedCollection<E> backingCollection, CacheConfig cacheConfig) {
        super(backingCollection);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheConfig.getSize()).build(CacheLoader.from(x$0 -> CachingAsyncDistributedCollection.super.contains(x$0)));
        this.cacheUpdater = event -> {
            this.cache.invalidate(event.element());
            this.eventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event(event)));
        };
        this.statusListener = status -> {
            this.log.debug("{} status changed to {}", (Object)this.name(), status);
            if (status == PrimitiveState.SUSPENDED || status == PrimitiveState.CLOSED) {
                this.cache.invalidateAll();
            }
        };
        super.addListener(this.cacheUpdater, MoreExecutors.directExecutor());
        super.addStateChangeListener(this.statusListener);
    }

    @Override
    public CompletableFuture<Boolean> add(E element) {
        return super.add(element).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(element);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
        return super.addAll(c).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                c.forEach(arg_0 -> this.cache.invalidate(arg_0));
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
        return super.retainAll(c).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                c.forEach(arg_0 -> this.cache.invalidate(arg_0));
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
        return super.removeAll(c).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                c.forEach(arg_0 -> this.cache.invalidate(arg_0));
            }
        });
    }

    @Override
    public CompletableFuture<Void> clear() {
        return super.clear().whenComplete((r, e) -> this.cache.invalidateAll());
    }

    @Override
    public CompletableFuture<Void> addListener(CollectionEventListener<E> listener, Executor executor) {
        this.eventListeners.put(listener, executor);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(CollectionEventListener<E> listener) {
        this.eventListeners.remove(listener);
        return CompletableFuture.completedFuture(null);
    }
}

