/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ReflectionUtils {
    private ReflectionUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Class<?> getClazz(String className) throws IOException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to load class: " + className, e);
        }
        return clazz;
    }

    private static <T> T getNewInstance(Class<T> clazz) throws IOException {
        T instance;
        try {
            instance = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException("Unable to instantiate class with 0 arguments: " + clazz.getName(), e);
        }
        return instance;
    }

    private static <T> T getNewInstance(Class<T> clazz, Class<?>[] parameterTypes, Object[] parameters) throws IOException {
        T instance;
        try {
            Constructor<T> constructor = clazz.getConstructor(parameterTypes);
            instance = constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Unable to instantiate class with " + parameters.length + " arguments: " + clazz.getName(), e);
        }
        return instance;
    }

    public static <T> T createClazzInstance(String className) throws IOException {
        Class<?> clazz = ReflectionUtils.getClazz(className);
        Object instance = ReflectionUtils.getNewInstance(clazz);
        return (T)instance;
    }

    public static <T> T createClazzInstance(String className, Class<?>[] parameterTypes, Object[] parameters) throws IOException {
        Class<?> clazz = ReflectionUtils.getClazz(className);
        Object instance = ReflectionUtils.getNewInstance(clazz, parameterTypes, parameters);
        return (T)instance;
    }
}

