/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.zeppelin.interpreter.remote.AppendOutputBuffer;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOutputRunner
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppendOutputRunner.class);
    public static final Long BUFFER_TIME_MS = new Long(100L);
    private static final Long SAFE_PROCESSING_TIME = new Long(10L);
    private static final Long SAFE_PROCESSING_STRING_SIZE = new Long(100000L);
    private final BlockingQueue<AppendOutputBuffer> queue = new LinkedBlockingQueue<AppendOutputBuffer>();
    private final RemoteInterpreterProcessListener listener;

    public AppendOutputRunner(RemoteInterpreterProcessListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        HashMap<String, StringBuilder> stringBufferMap = new HashMap<String, StringBuilder>();
        LinkedList<AppendOutputBuffer> list = new LinkedList<AppendOutputBuffer>();
        try {
            list.add(this.queue.take());
        }
        catch (InterruptedException e) {
            LOGGER.error("Wait for OutputBuffer queue interrupted: {}", (Object)e.getMessage());
        }
        Long processingStartTime = System.currentTimeMillis();
        this.queue.drainTo(list);
        for (AppendOutputBuffer buffer : list) {
            String noteId = buffer.getNoteId();
            String paragraphId = buffer.getParagraphId();
            int index = buffer.getIndex();
            String stringBufferKey = noteId + ":" + paragraphId + ":" + index;
            StringBuilder builder = stringBufferMap.containsKey(stringBufferKey) ? (StringBuilder)stringBufferMap.get(stringBufferKey) : new StringBuilder();
            builder.append(buffer.getData());
            stringBufferMap.put(stringBufferKey, builder);
        }
        Long processingTime = System.currentTimeMillis() - processingStartTime;
        if (processingTime > SAFE_PROCESSING_TIME) {
            LOGGER.warn("Processing time for buffered append-output is high: {} milliseconds.", (Object)processingTime);
        } else {
            LOGGER.debug("Processing time for append-output took {} milliseconds", (Object)processingTime);
        }
        Long sizeProcessed = new Long(0L);
        for (Map.Entry stringBufferMapEntry : stringBufferMap.entrySet()) {
            String stringBufferKey = (String)stringBufferMapEntry.getKey();
            StringBuilder buffer = (StringBuilder)stringBufferMapEntry.getValue();
            sizeProcessed = sizeProcessed + (long)buffer.length();
            String[] keys = stringBufferKey.split(":");
            this.listener.onOutputAppend(keys[0], keys[1], Integer.parseInt(keys[2]), buffer.toString());
        }
        if (sizeProcessed > SAFE_PROCESSING_STRING_SIZE) {
            LOGGER.warn("Processing size for buffered append-output is high: {} characters.", (Object)sizeProcessed);
        } else {
            LOGGER.debug("Processing size for append-output is {} characters", (Object)sizeProcessed);
        }
    }

    public void appendBuffer(String noteId, String paragraphId, int index, String outputToAppend) {
        this.queue.offer(new AppendOutputBuffer(noteId, paragraphId, index, outputToAppend));
    }
}

