/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.monitor.jvm.GcNames;

public class JvmStats
implements Streamable,
ToXContent {
    private static final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    long timestamp = -1L;
    long uptime;
    Mem mem;
    Threads threads;
    GarbageCollectors gc;
    List<BufferPool> bufferPools;
    Classes classes;

    public static JvmStats jvmStats() {
        JvmStats stats = new JvmStats(System.currentTimeMillis(), runtimeMXBean.getUptime());
        stats.mem = new Mem();
        MemoryUsage memUsage = memoryMXBean.getHeapMemoryUsage();
        stats.mem.heapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        stats.mem.heapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        stats.mem.heapMax = memUsage.getMax() < 0L ? 0L : memUsage.getMax();
        memUsage = memoryMXBean.getNonHeapMemoryUsage();
        stats.mem.nonHeapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        stats.mem.nonHeapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<MemoryPool> pools = new ArrayList<MemoryPool>();
        for (int i = 0; i < memoryPoolMXBeans.size(); ++i) {
            try {
                MemoryPoolMXBean memoryPoolMXBean = memoryPoolMXBeans.get(i);
                MemoryUsage usage = memoryPoolMXBean.getUsage();
                MemoryUsage peakUsage = memoryPoolMXBean.getPeakUsage();
                String name = GcNames.getByMemoryPoolName(memoryPoolMXBean.getName(), null);
                if (name == null) continue;
                pools.add(new MemoryPool(name, usage.getUsed() < 0L ? 0L : usage.getUsed(), usage.getMax() < 0L ? 0L : usage.getMax(), peakUsage.getUsed() < 0L ? 0L : peakUsage.getUsed(), peakUsage.getMax() < 0L ? 0L : peakUsage.getMax()));
                continue;
            }
            catch (OutOfMemoryError err) {
                throw err;
            }
            catch (Throwable err) {
                // empty catch block
            }
        }
        stats.mem.pools = pools.toArray(new MemoryPool[pools.size()]);
        stats.threads = new Threads();
        stats.threads.count = threadMXBean.getThreadCount();
        stats.threads.peakCount = threadMXBean.getPeakThreadCount();
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        stats.gc = new GarbageCollectors();
        stats.gc.collectors = new GarbageCollector[gcMxBeans.size()];
        for (int i = 0; i < stats.gc.collectors.length; ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            stats.gc.collectors[i] = new GarbageCollector();
            stats.gc.collectors[i].name = GcNames.getByGcName(gcMxBean.getName(), gcMxBean.getName());
            stats.gc.collectors[i].collectionCount = gcMxBean.getCollectionCount();
            stats.gc.collectors[i].collectionTime = gcMxBean.getCollectionTime();
        }
        try {
            List<BufferPoolMXBean> bufferPools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
            stats.bufferPools = new ArrayList<BufferPool>(bufferPools.size());
            for (BufferPoolMXBean bufferPool : bufferPools) {
                stats.bufferPools.add(new BufferPool(bufferPool.getName(), bufferPool.getCount(), bufferPool.getTotalCapacity(), bufferPool.getMemoryUsed()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stats.classes = new Classes();
        stats.classes.loadedClassCount = classLoadingMXBean.getLoadedClassCount();
        stats.classes.totalLoadedClassCount = classLoadingMXBean.getTotalLoadedClassCount();
        stats.classes.unloadedClassCount = classLoadingMXBean.getUnloadedClassCount();
        return stats;
    }

    private JvmStats() {
    }

    public JvmStats(long timestamp, long uptime) {
        this.timestamp = timestamp;
        this.uptime = uptime;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TimeValue getUptime() {
        return new TimeValue(this.uptime);
    }

    public Mem getMem() {
        return this.mem;
    }

    public Threads getThreads() {
        return this.threads;
    }

    public GarbageCollectors getGc() {
        return this.gc;
    }

    public List<BufferPool> getBufferPools() {
        return this.bufferPools;
    }

    public Classes getClasses() {
        return this.classes;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.JVM);
        builder.field(Fields.TIMESTAMP, this.timestamp);
        builder.timeValueField(Fields.UPTIME_IN_MILLIS, Fields.UPTIME, this.uptime);
        if (this.mem != null) {
            builder.startObject(Fields.MEM);
            builder.byteSizeField(Fields.HEAP_USED_IN_BYTES, Fields.HEAP_USED, this.mem.heapUsed);
            if (this.mem.getHeapUsedPercent() >= 0) {
                builder.field(Fields.HEAP_USED_PERCENT, (int)this.mem.getHeapUsedPercent());
            }
            builder.byteSizeField(Fields.HEAP_COMMITTED_IN_BYTES, Fields.HEAP_COMMITTED, this.mem.heapCommitted);
            builder.byteSizeField(Fields.HEAP_MAX_IN_BYTES, Fields.HEAP_MAX, this.mem.heapMax);
            builder.byteSizeField(Fields.NON_HEAP_USED_IN_BYTES, Fields.NON_HEAP_USED, this.mem.nonHeapUsed);
            builder.byteSizeField(Fields.NON_HEAP_COMMITTED_IN_BYTES, Fields.NON_HEAP_COMMITTED, this.mem.nonHeapCommitted);
            builder.startObject(Fields.POOLS);
            for (MemoryPool pool : this.mem) {
                builder.startObject(pool.getName(), XContentBuilder.FieldCaseConversion.NONE);
                builder.byteSizeField(Fields.USED_IN_BYTES, Fields.USED, pool.used);
                builder.byteSizeField(Fields.MAX_IN_BYTES, Fields.MAX, pool.max);
                builder.byteSizeField(Fields.PEAK_USED_IN_BYTES, Fields.PEAK_USED, pool.peakUsed);
                builder.byteSizeField(Fields.PEAK_MAX_IN_BYTES, Fields.PEAK_MAX, pool.peakMax);
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (this.threads != null) {
            builder.startObject(Fields.THREADS);
            builder.field(Fields.COUNT, this.threads.getCount());
            builder.field(Fields.PEAK_COUNT, this.threads.getPeakCount());
            builder.endObject();
        }
        if (this.gc != null) {
            builder.startObject(Fields.GC);
            builder.startObject(Fields.COLLECTORS);
            for (GarbageCollector collector : this.gc) {
                builder.startObject(collector.getName(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field(Fields.COLLECTION_COUNT, collector.getCollectionCount());
                builder.timeValueField(Fields.COLLECTION_TIME_IN_MILLIS, Fields.COLLECTION_TIME, collector.collectionTime);
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (this.bufferPools != null) {
            builder.startObject(Fields.BUFFER_POOLS);
            for (BufferPool bufferPool : this.bufferPools) {
                builder.startObject(bufferPool.getName(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field(Fields.COUNT, bufferPool.getCount());
                builder.byteSizeField(Fields.USED_IN_BYTES, Fields.USED, bufferPool.used);
                builder.byteSizeField(Fields.TOTAL_CAPACITY_IN_BYTES, Fields.TOTAL_CAPACITY, bufferPool.totalCapacity);
                builder.endObject();
            }
            builder.endObject();
        }
        if (this.classes != null) {
            builder.startObject(Fields.CLASSES);
            builder.field(Fields.CURRENT_LOADED_COUNT, this.classes.getLoadedClassCount());
            builder.field(Fields.TOTAL_LOADED_COUNT, this.classes.getTotalLoadedClassCount());
            builder.field(Fields.TOTAL_UNLOADED_COUNT, this.classes.getUnloadedClassCount());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static JvmStats readJvmStats(StreamInput in) throws IOException {
        JvmStats jvmStats = new JvmStats();
        jvmStats.readFrom(in);
        return jvmStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.uptime = in.readVLong();
        this.mem = Mem.readMem(in);
        this.threads = Threads.readThreads(in);
        this.gc = GarbageCollectors.readGarbageCollectors(in);
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.bufferPools = new ArrayList<BufferPool>(size);
            for (int i = 0; i < size; ++i) {
                BufferPool bufferPool = new BufferPool();
                bufferPool.readFrom(in);
                this.bufferPools.add(bufferPool);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVLong(this.uptime);
        this.mem.writeTo(out);
        this.threads.writeTo(out);
        this.gc.writeTo(out);
        if (this.bufferPools == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.bufferPools.size());
            for (BufferPool bufferPool : this.bufferPools) {
                bufferPool.writeTo(out);
            }
        }
    }

    public static class Classes
    implements Streamable {
        long loadedClassCount;
        long totalLoadedClassCount;
        long unloadedClassCount;

        Classes() {
        }

        public Classes(long loadedClassCount, long totalLoadedClassCount, long unloadedClassCount) {
            this.loadedClassCount = loadedClassCount;
            this.totalLoadedClassCount = totalLoadedClassCount;
            this.unloadedClassCount = unloadedClassCount;
        }

        public long getLoadedClassCount() {
            return this.loadedClassCount;
        }

        public long getTotalLoadedClassCount() {
            return this.totalLoadedClassCount;
        }

        public long getUnloadedClassCount() {
            return this.unloadedClassCount;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.loadedClassCount = in.readLong();
            this.totalLoadedClassCount = in.readLong();
            this.unloadedClassCount = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.loadedClassCount);
            out.writeLong(this.totalLoadedClassCount);
            out.writeLong(this.unloadedClassCount);
        }
    }

    public static class BufferPool
    implements Streamable {
        String name;
        long count;
        long totalCapacity;
        long used;

        BufferPool() {
        }

        public BufferPool(String name, long count, long totalCapacity, long used) {
            this.name = name;
            this.count = count;
            this.totalCapacity = totalCapacity;
            this.used = used;
        }

        public String getName() {
            return this.name;
        }

        public long getCount() {
            return this.count;
        }

        public ByteSizeValue getTotalCapacity() {
            return new ByteSizeValue(this.totalCapacity);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.used);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.count = in.readLong();
            this.totalCapacity = in.readLong();
            this.used = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeLong(this.count);
            out.writeLong(this.totalCapacity);
            out.writeLong(this.used);
        }
    }

    public static class Mem
    implements Streamable,
    Iterable<MemoryPool> {
        long heapCommitted;
        long heapUsed;
        long heapMax;
        long nonHeapCommitted;
        long nonHeapUsed;
        MemoryPool[] pools = new MemoryPool[0];

        Mem() {
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public Iterator<MemoryPool> iterator() {
            return Iterators.forArray(this.pools);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.heapCommitted = in.readVLong();
            this.heapUsed = in.readVLong();
            this.nonHeapCommitted = in.readVLong();
            this.nonHeapUsed = in.readVLong();
            this.heapMax = in.readVLong();
            this.pools = new MemoryPool[in.readVInt()];
            for (int i = 0; i < this.pools.length; ++i) {
                this.pools[i] = MemoryPool.readMemoryPool(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapCommitted);
            out.writeVLong(this.heapUsed);
            out.writeVLong(this.nonHeapCommitted);
            out.writeVLong(this.nonHeapUsed);
            out.writeVLong(this.heapMax);
            out.writeVInt(this.pools.length);
            for (MemoryPool pool : this.pools) {
                pool.writeTo(out);
            }
        }

        public ByteSizeValue getHeapCommitted() {
            return new ByteSizeValue(this.heapCommitted);
        }

        public ByteSizeValue getHeapUsed() {
            return new ByteSizeValue(this.heapUsed);
        }

        public ByteSizeValue getHeapMax() {
            return new ByteSizeValue(this.heapMax);
        }

        public short getHeapUsedPercent() {
            if (this.heapMax == 0L) {
                return -1;
            }
            return (short)(this.heapUsed * 100L / this.heapMax);
        }

        public ByteSizeValue getNonHeapCommitted() {
            return new ByteSizeValue(this.nonHeapCommitted);
        }

        public ByteSizeValue getNonHeapUsed() {
            return new ByteSizeValue(this.nonHeapUsed);
        }
    }

    public static class MemoryPool
    implements Streamable {
        String name;
        long used;
        long max;
        long peakUsed;
        long peakMax;

        MemoryPool() {
        }

        public MemoryPool(String name, long used, long max, long peakUsed, long peakMax) {
            this.name = name;
            this.used = used;
            this.max = max;
            this.peakUsed = peakUsed;
            this.peakMax = peakMax;
        }

        public static MemoryPool readMemoryPool(StreamInput in) throws IOException {
            MemoryPool pool = new MemoryPool();
            pool.readFrom(in);
            return pool;
        }

        public String getName() {
            return this.name;
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getMax() {
            return new ByteSizeValue(this.max);
        }

        public ByteSizeValue getPeakUsed() {
            return new ByteSizeValue(this.peakUsed);
        }

        public ByteSizeValue getPeakMax() {
            return new ByteSizeValue(this.peakMax);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.used = in.readVLong();
            this.max = in.readVLong();
            this.peakUsed = in.readVLong();
            this.peakMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVLong(this.used);
            out.writeVLong(this.max);
            out.writeVLong(this.peakUsed);
            out.writeVLong(this.peakMax);
        }
    }

    public static class Threads
    implements Streamable {
        int count;
        int peakCount;

        Threads() {
        }

        public int getCount() {
            return this.count;
        }

        public int getPeakCount() {
            return this.peakCount;
        }

        public static Threads readThreads(StreamInput in) throws IOException {
            Threads threads = new Threads();
            threads.readFrom(in);
            return threads;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.count = in.readVInt();
            this.peakCount = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.count);
            out.writeVInt(this.peakCount);
        }
    }

    public static class GarbageCollector
    implements Streamable {
        String name;
        long collectionCount;
        long collectionTime;

        GarbageCollector() {
        }

        public static GarbageCollector readGarbageCollector(StreamInput in) throws IOException {
            GarbageCollector gc = new GarbageCollector();
            gc.readFrom(in);
            return gc;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.collectionCount = in.readVLong();
            this.collectionTime = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVLong(this.collectionCount);
            out.writeVLong(this.collectionTime);
        }

        public String getName() {
            return this.name;
        }

        public long getCollectionCount() {
            return this.collectionCount;
        }

        public TimeValue getCollectionTime() {
            return new TimeValue(this.collectionTime, TimeUnit.MILLISECONDS);
        }
    }

    public static class GarbageCollectors
    implements Streamable,
    Iterable<GarbageCollector> {
        GarbageCollector[] collectors;

        GarbageCollectors() {
        }

        public static GarbageCollectors readGarbageCollectors(StreamInput in) throws IOException {
            GarbageCollectors collectors = new GarbageCollectors();
            collectors.readFrom(in);
            return collectors;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.collectors = new GarbageCollector[in.readVInt()];
            for (int i = 0; i < this.collectors.length; ++i) {
                this.collectors[i] = GarbageCollector.readGarbageCollector(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.collectors.length);
            for (GarbageCollector gc : this.collectors) {
                gc.writeTo(out);
            }
        }

        public GarbageCollector[] getCollectors() {
            return this.collectors;
        }

        @Override
        public Iterator<GarbageCollector> iterator() {
            return Iterators.forArray(this.collectors);
        }
    }

    static final class Fields {
        static final XContentBuilderString JVM = new XContentBuilderString("jvm");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString UPTIME = new XContentBuilderString("uptime");
        static final XContentBuilderString UPTIME_IN_MILLIS = new XContentBuilderString("uptime_in_millis");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString HEAP_USED = new XContentBuilderString("heap_used");
        static final XContentBuilderString HEAP_USED_IN_BYTES = new XContentBuilderString("heap_used_in_bytes");
        static final XContentBuilderString HEAP_USED_PERCENT = new XContentBuilderString("heap_used_percent");
        static final XContentBuilderString HEAP_MAX = new XContentBuilderString("heap_max");
        static final XContentBuilderString HEAP_MAX_IN_BYTES = new XContentBuilderString("heap_max_in_bytes");
        static final XContentBuilderString HEAP_COMMITTED = new XContentBuilderString("heap_committed");
        static final XContentBuilderString HEAP_COMMITTED_IN_BYTES = new XContentBuilderString("heap_committed_in_bytes");
        static final XContentBuilderString NON_HEAP_USED = new XContentBuilderString("non_heap_used");
        static final XContentBuilderString NON_HEAP_USED_IN_BYTES = new XContentBuilderString("non_heap_used_in_bytes");
        static final XContentBuilderString NON_HEAP_COMMITTED = new XContentBuilderString("non_heap_committed");
        static final XContentBuilderString NON_HEAP_COMMITTED_IN_BYTES = new XContentBuilderString("non_heap_committed_in_bytes");
        static final XContentBuilderString POOLS = new XContentBuilderString("pools");
        static final XContentBuilderString USED = new XContentBuilderString("used");
        static final XContentBuilderString USED_IN_BYTES = new XContentBuilderString("used_in_bytes");
        static final XContentBuilderString MAX = new XContentBuilderString("max");
        static final XContentBuilderString MAX_IN_BYTES = new XContentBuilderString("max_in_bytes");
        static final XContentBuilderString PEAK_USED = new XContentBuilderString("peak_used");
        static final XContentBuilderString PEAK_USED_IN_BYTES = new XContentBuilderString("peak_used_in_bytes");
        static final XContentBuilderString PEAK_MAX = new XContentBuilderString("peak_max");
        static final XContentBuilderString PEAK_MAX_IN_BYTES = new XContentBuilderString("peak_max_in_bytes");
        static final XContentBuilderString THREADS = new XContentBuilderString("threads");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString PEAK_COUNT = new XContentBuilderString("peak_count");
        static final XContentBuilderString GC = new XContentBuilderString("gc");
        static final XContentBuilderString COLLECTORS = new XContentBuilderString("collectors");
        static final XContentBuilderString COLLECTION_COUNT = new XContentBuilderString("collection_count");
        static final XContentBuilderString COLLECTION_TIME = new XContentBuilderString("collection_time");
        static final XContentBuilderString COLLECTION_TIME_IN_MILLIS = new XContentBuilderString("collection_time_in_millis");
        static final XContentBuilderString BUFFER_POOLS = new XContentBuilderString("buffer_pools");
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString TOTAL_CAPACITY = new XContentBuilderString("total_capacity");
        static final XContentBuilderString TOTAL_CAPACITY_IN_BYTES = new XContentBuilderString("total_capacity_in_bytes");
        static final XContentBuilderString CLASSES = new XContentBuilderString("classes");
        static final XContentBuilderString CURRENT_LOADED_COUNT = new XContentBuilderString("current_loaded_count");
        static final XContentBuilderString TOTAL_LOADED_COUNT = new XContentBuilderString("total_loaded_count");
        static final XContentBuilderString TOTAL_UNLOADED_COUNT = new XContentBuilderString("total_unloaded_count");

        Fields() {
        }
    }
}

