/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;

public class RestoreInProgress
extends AbstractDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "restore";
    public static final RestoreInProgress PROTO = new RestoreInProgress(new Entry[0]);
    private final List<Entry> entries;

    public RestoreInProgress(List<Entry> entries) {
        this.entries = entries;
    }

    public RestoreInProgress(Entry ... entries) {
        this.entries = Arrays.asList(entries);
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(SnapshotId snapshotId) {
        for (Entry entry : this.entries) {
            if (!snapshotId.equals(entry.snapshotId())) continue;
            return entry;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreInProgress that = (RestoreInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public RestoreInProgress readFrom(StreamInput in) throws IOException {
        Entry[] entries = new Entry[in.readVInt()];
        for (int i = 0; i < entries.length; ++i) {
            SnapshotId snapshotId = SnapshotId.readSnapshotId(in);
            State state = State.fromValue(in.readByte());
            int indices = in.readVInt();
            ArrayList<String> indexBuilder = new ArrayList<String>();
            for (int j = 0; j < indices; ++j) {
                indexBuilder.add(in.readString());
            }
            ImmutableMap.Builder<ShardId, ShardRestoreStatus> builder = ImmutableMap.builder();
            int shards = in.readVInt();
            for (int j = 0; j < shards; ++j) {
                ShardId shardId = ShardId.readShardId(in);
                ShardRestoreStatus shardState = ShardRestoreStatus.readShardRestoreStatus(in);
                builder.put(shardId, shardState);
            }
            entries[i] = new Entry(snapshotId, state, Collections.unmodifiableList(indexBuilder), builder.build());
        }
        return new RestoreInProgress(entries);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries.size());
        for (Entry entry : this.entries) {
            entry.snapshotId().writeTo(out);
            out.writeByte(entry.state().value());
            out.writeVInt(entry.indices().size());
            for (String index : entry.indices()) {
                out.writeString(index);
            }
            out.writeVInt(entry.shards().size());
            for (Map.Entry shardEntry : entry.shards().entrySet()) {
                ((ShardId)shardEntry.getKey()).writeTo(out);
                ((ShardRestoreStatus)shardEntry.getValue()).writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (Entry entry : this.entries) {
            this.toXContent(entry, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot", entry.snapshotId().getSnapshot());
        builder.field("repository", entry.snapshotId().getRepository());
        builder.field("state", (Object)entry.state());
        builder.startArray("indices");
        for (String index : entry.indices()) {
            builder.value(index);
        }
        builder.endArray();
        builder.startArray("shards");
        for (Map.Entry shardEntry : entry.shards.entrySet()) {
            ShardId shardId = (ShardId)shardEntry.getKey();
            ShardRestoreStatus status = (ShardRestoreStatus)shardEntry.getValue();
            builder.startObject();
            builder.field("index", shardId.getIndex());
            builder.field("shard", shardId.getId());
            builder.field("state", (Object)status.state());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    public static enum State {
        INIT(0),
        STARTED(1),
        SUCCESS(2),
        FAILURE(3);

        private byte value;

        private State(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this == SUCCESS || this == FAILURE;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILURE;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardRestoreStatus {
        private State state;
        private String nodeId;
        private String reason;

        private ShardRestoreStatus() {
        }

        public ShardRestoreStatus(String nodeId) {
            this(nodeId, State.INIT);
        }

        public ShardRestoreStatus(String nodeId, State state) {
            this(nodeId, state, null);
        }

        public ShardRestoreStatus(String nodeId, State state, String reason) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
        }

        public State state() {
            return this.state;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String reason() {
            return this.reason;
        }

        public static ShardRestoreStatus readShardRestoreStatus(StreamInput in) throws IOException {
            ShardRestoreStatus shardSnapshotStatus = new ShardRestoreStatus();
            shardSnapshotStatus.readFrom(in);
            return shardSnapshotStatus;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = State.fromValue(in.readByte());
            this.reason = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardRestoreStatus status = (ShardRestoreStatus)o;
            if (this.nodeId != null ? !this.nodeId.equals(status.nodeId) : status.nodeId != null) {
                return false;
            }
            if (this.reason != null ? !this.reason.equals(status.reason) : status.reason != null) {
                return false;
            }
            return this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            return result;
        }
    }

    public static class Entry {
        private final State state;
        private final SnapshotId snapshotId;
        private final ImmutableMap<ShardId, ShardRestoreStatus> shards;
        private final List<String> indices;

        public Entry(SnapshotId snapshotId, State state, List<String> indices, ImmutableMap<ShardId, ShardRestoreStatus> shards) {
            this.snapshotId = snapshotId;
            this.state = state;
            this.indices = indices;
            this.shards = shards == null ? ImmutableMap.of() : shards;
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public ImmutableMap<ShardId, ShardRestoreStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<String> indices() {
            return this.indices;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.snapshotId.equals(entry.snapshotId)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            return this.state == entry.state;
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshotId.hashCode();
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            return result;
        }
    }
}

