/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.elasticsearch.client;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.elasticsearch.client.ElasticsearchClientType;

public class ElasticsearchClientTypeBuilder {
    private static final ElasticsearchClientType DEFAULT_ELASTICSEARCH_CLIENT_TYPE = ElasticsearchClientType.TRANSPORT;

    public static Build withPropertyValue(String propertyValue) {
        return new Builder(propertyValue);
    }

    private static class Builder
    implements Build {
        private final String propertyValue;

        private Builder(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        @Override
        public ElasticsearchClientType build() {
            boolean isEmpty = StringUtils.isEmpty(this.propertyValue);
            return isEmpty ? DEFAULT_ELASTICSEARCH_CLIENT_TYPE : this.getElasticsearchClientType(this.propertyValue);
        }

        private ElasticsearchClientType getElasticsearchClientType(String propertyValue) {
            boolean isExistingValue = Arrays.stream(ElasticsearchClientType.values()).anyMatch(clientType -> clientType.toString().equalsIgnoreCase(propertyValue));
            return isExistingValue ? ElasticsearchClientType.valueOf(propertyValue.toUpperCase()) : ElasticsearchClientType.UNKNOWN;
        }
    }

    public static interface Build {
        public ElasticsearchClientType build();
    }
}

