/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.OfflineSorter;

public class ExternalRefSorter
implements BytesRefSorter,
Closeable {
    private final OfflineSorter sort;
    private OfflineSorter.ByteSequencesWriter writer;
    private Path input;
    private Path sorted;

    public ExternalRefSorter(OfflineSorter sort) throws IOException {
        this.sort = sort;
        this.input = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "RefSorter-", ".raw", new FileAttribute[0]);
        this.writer = new OfflineSorter.ByteSequencesWriter(this.input);
    }

    @Override
    public void add(BytesRef utf8) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException();
        }
        this.writer.write(utf8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesRefIterator iterator() throws IOException {
        block5: {
            block6: {
                block4: {
                    if (this.sorted != null) break block5;
                    this.closeWriter();
                    this.sorted = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "RefSorter-", ".sorted", new FileAttribute[0]);
                    boolean success = false;
                    try {
                        this.sort.sort(this.input, this.sorted);
                        success = true;
                        if (!success) break block4;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            Files.delete(this.input);
                        } else {
                            IOUtils.deleteFilesIgnoringExceptions(this.input);
                        }
                        throw throwable;
                    }
                    Files.delete(this.input);
                    break block6;
                }
                IOUtils.deleteFilesIgnoringExceptions(this.input);
            }
            this.input = null;
        }
        return new ByteSequenceIterator(new OfflineSorter.ByteSequencesReader(this.sorted));
    }

    private void closeWriter() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block5: {
            block4: {
                boolean success = false;
                try {
                    this.closeWriter();
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.deleteFilesIfExist(this.input, this.sorted);
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions(this.input, this.sorted);
                    }
                    throw throwable;
                }
                IOUtils.deleteFilesIfExist(this.input, this.sorted);
                break block5;
            }
            IOUtils.deleteFilesIgnoringExceptions(this.input, this.sorted);
        }
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.sort.getComparator();
    }

    class ByteSequenceIterator
    implements BytesRefIterator {
        private final OfflineSorter.ByteSequencesReader reader;
        private BytesRef scratch = new BytesRef();

        public ByteSequenceIterator(OfflineSorter.ByteSequencesReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BytesRef next() throws IOException {
            BytesRef bytesRef;
            block6: {
                if (this.scratch == null) {
                    return null;
                }
                boolean success = false;
                try {
                    byte[] next = this.reader.read();
                    if (next != null) {
                        this.scratch.bytes = next;
                        this.scratch.length = next.length;
                        this.scratch.offset = 0;
                    } else {
                        IOUtils.close(this.reader);
                        this.scratch = null;
                    }
                    success = true;
                    bytesRef = this.scratch;
                    if (success) break block6;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(this.reader);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(this.reader);
            }
            return bytesRef;
        }
    }
}

