/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.BufferPool;
import io.atomix.storage.buffer.UnsafeHeapBuffer;
import io.atomix.storage.buffer.UnsafeHeapBytes;
import io.atomix.utils.concurrent.ReferenceCounted;
import io.atomix.utils.concurrent.ReferenceFactory;
import io.atomix.utils.concurrent.ReferenceManager;

public class UnsafeHeapBufferPool
extends BufferPool {
    public UnsafeHeapBufferPool() {
        super(new HeapBufferFactory());
    }

    public void release(Buffer reference) {
        reference.rewind();
        super.release((ReferenceCounted)reference);
    }

    private static class HeapBufferFactory
    implements ReferenceFactory<Buffer> {
        private HeapBufferFactory() {
        }

        public Buffer createReference(ReferenceManager<Buffer> manager) {
            UnsafeHeapBuffer buffer = new UnsafeHeapBuffer(UnsafeHeapBytes.allocate(1024), manager);
            buffer.reset(0, 1024, Integer.MAX_VALUE);
            return buffer;
        }
    }
}

