/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.vocabulary.RDF;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class XMLInputSAX
extends SPARQLResult {
    public XMLInputSAX(InputStream in, Model model) {
        this.worker(new InputSource(in), model);
    }

    public XMLInputSAX(Reader in, Model model) {
        this.worker(new InputSource(in), model);
    }

    public XMLInputSAX(String str2, Model model) {
        this.worker(new InputSource(str2), model);
    }

    private void worker(InputSource in, Model model) {
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            ResultSetXMLHandler2 handler = new ResultSetXMLHandler2();
            xr.setContentHandler(handler);
            xr.parse(in);
            if (handler.isBooleanResult) {
                this.set(handler.askResult);
                return;
            }
            ResultSetStream rss = new ResultSetStream(handler.variables, model, new QueryIterPlainWrapper(handler.results.iterator()));
            this.set(rss);
        }
        catch (SAXException ex) {
            throw new ResultSetException("Problems parsing file (SAXException)", ex);
        }
        catch (IOException ex) {
            throw new ResultSetException("Problems parsing file (IOException)", ex);
        }
    }

    static class ResultSetXMLHandler2
    implements ContentHandler {
        static final String namespace = "http://www.w3.org/2005/sparql-results#";
        static final String variableElt = "variable";
        static final String resultElt = "result";
        boolean isBooleanResult = false;
        boolean askResult = false;
        int rowCount = 0;
        LabelToNode bNodes = SyntaxLabels.createLabelToNode();
        boolean accumulate = false;
        StringBuffer buff = new StringBuffer();
        List<String> variables = new ArrayList<String>();
        List<Binding> results = new ArrayList<Binding>();
        BindingMap binding = null;
        String varName;
        String datatype = null;
        String langTag = null;
        String rdfPrefix = "rdf";

        ResultSetXMLHandler2() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (uri.equals(RDF.getURI())) {
                this.rdfPrefix = prefix;
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String ns, String localName, String qName, Attributes attrs) throws SAXException {
            if (!ns.equals(namespace)) {
                return;
            }
            if (localName.equals(variableElt)) {
                if (attrs.getValue("name") != null) {
                    String name = attrs.getValue("name");
                    this.variables.add(name);
                }
                return;
            }
            if (localName.equals("results")) {
                return;
            }
            if (localName.equals("boolean")) {
                this.isBooleanResult = true;
            }
            if (localName.equals(resultElt)) {
                this.binding = BindingFactory.create();
                return;
            }
            if (localName.equals("binding")) {
                this.varName = attrs.getValue("name");
                return;
            }
            if (localName.equals("uri")) {
                this.startElementURI(ns, localName, qName, attrs);
                return;
            }
            if (localName.equals("literal")) {
                this.startElementLiteral(ns, localName, qName, attrs);
                return;
            }
            if (localName.equals("bnode")) {
                this.startElementBNode(ns, localName, qName, attrs);
                return;
            }
            if (localName.equals("unbound")) {
                return;
            }
        }

        @Override
        public void endElement(String ns, String localName, String qName) throws SAXException {
            if (!ns.equals(namespace)) {
                return;
            }
            if (localName.equals("results")) {
                return;
            }
            if (localName.equals("boolean")) {
                this.endElementBoolean();
                return;
            }
            if (localName.equals(resultElt)) {
                this.varName = null;
                this.datatype = null;
                this.langTag = null;
                this.results.add(this.binding);
                this.binding = null;
                return;
            }
            if (localName.equals("binding")) {
                this.varName = null;
                return;
            }
            if (localName.equals("uri")) {
                this.endElementURI(ns, localName, qName);
                return;
            }
            if (localName.equals("literal")) {
                this.endElementLiteral(ns, localName, qName);
                return;
            }
            if (localName.equals("bnode")) {
                this.endElementBNode(ns, localName, qName);
                return;
            }
            if (localName.equals("unbound")) {
                return;
            }
        }

        private boolean checkVarName(String cxtMsg) {
            if (cxtMsg == null) {
                cxtMsg = "";
            }
            if (this.varName == null) {
                Log.warn(this, "No variable name in scope: " + cxtMsg);
                return false;
            }
            if (!this.variables.contains(this.varName)) {
                Log.warn(this, "Variable name '" + this.varName + "'not declared: " + cxtMsg);
                return false;
            }
            return true;
        }

        private void startElementURI(String ns, String localName, String name, Attributes attrs) {
            this.startAccumulate();
        }

        private void endElementURI(String ns, String localName, String name) {
            this.endAccumulate();
            String uri = this.buff.toString();
            Node n = NodeFactory.createURI(uri);
            if (this.checkVarName("URI: " + uri)) {
                ResultSetXMLHandler2.addBinding(this.binding, Var.alloc(this.varName), n);
            }
        }

        private void startElementLiteral(String ns, String localName, String name, Attributes attrs) {
            if (attrs.getValue("datatype") != null) {
                this.datatype = attrs.getValue("datatype");
            }
            if (attrs.getValue("xml:lang") != null) {
                this.langTag = attrs.getValue("xml:lang");
            }
            this.startAccumulate();
        }

        private void endElementLiteral(String ns, String localName, String name) {
            this.endAccumulate();
            String lexicalForm = this.buff.toString();
            RDFDatatype dType = null;
            if (this.datatype != null) {
                dType = TypeMapper.getInstance().getSafeTypeByName(this.datatype);
            }
            Node n = NodeFactory.createLiteral(lexicalForm.toString(), this.langTag, dType);
            if (this.checkVarName("Literal: " + FmtUtils.stringForNode(n))) {
                ResultSetXMLHandler2.addBinding(this.binding, Var.alloc(this.varName), n);
            }
            this.datatype = null;
            this.langTag = null;
            this.varName = null;
        }

        private void endElementBoolean() {
            this.endAccumulate();
            String result = this.buff.toString();
            if (result.equals("true")) {
                this.askResult = true;
                return;
            }
            if (result.equalsIgnoreCase("false")) {
                this.askResult = false;
                return;
            }
            throw new ResultSetException("Unknown boolean value: " + result);
        }

        private void startElementBNode(String ns, String localName, String name, Attributes attrs) {
            this.startAccumulate();
        }

        private void endElementBNode(String ns, String localName, String name) {
            this.endAccumulate();
            String bnodeId = this.buff.toString();
            Node node = (Node)this.bNodes.get(null, bnodeId);
            if (this.checkVarName("BNode: " + bnodeId)) {
                ResultSetXMLHandler2.addBinding(this.binding, Var.alloc(this.varName), node);
            }
        }

        private void startAccumulate() {
            this.buff.setLength(0);
            this.accumulate = true;
        }

        private void endAccumulate() {
            this.accumulate = false;
        }

        @Override
        public void characters(char[] chars, int start, int finish) throws SAXException {
            if (this.accumulate) {
                if (this.buff == null) {
                    this.buff = new StringBuffer();
                }
                this.buff.append(chars, start, finish);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        protected static void addBinding(BindingMap binding, Var var, Node value) {
            Node n = binding.get(var);
            if (n != null) {
                if (n.equals(value)) {
                    return;
                }
                Log.warn(SPARQLResult.class, String.format("Multiple occurences of a binding for variable '%s' with different values - ignored", var.getName()));
                return;
            }
            binding.add(var, value);
        }
    }
}

