/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.sparql.util.IterLib;

abstract class PFuncAssignBase
extends PFuncSimple {
    PFuncAssignBase() {
    }

    @Override
    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        try {
            if (subject.isVariable()) {
                Log.warn(this, "Variable found: expected a value: " + subject);
                return IterLib.noResults(execCxt);
            }
            Node r = this.calc(subject);
            if (Var.isVar(object)) {
                return IterLib.oneResult(binding, Var.alloc(object), r, execCxt);
            }
            if (r.equals(object)) {
                return IterLib.result(binding, execCxt);
            }
            return IterLib.noResults(execCxt);
        }
        catch (Exception ex) {
            Log.warn(this, "Exception: " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public abstract Node calc(Node var1);
}

