/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.leviathan;

import java.math.BigInteger;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;

public class factorial
extends FunctionBase1 {
    @Override
    public NodeValue exec(NodeValue v) {
        BigInteger i = v.getInteger();
        switch (i.compareTo(BigInteger.ZERO)) {
            case 0: {
                return NodeValue.makeInteger(BigInteger.ONE);
            }
            case -1: {
                throw new ExprEvalException("Cannot evaluate a negative factorial");
            }
            case 1: {
                BigInteger res = i.add(BigInteger.ZERO);
                i = i.subtract(BigInteger.ONE);
                while (i.compareTo(BigInteger.ZERO) != 0) {
                    res = res.multiply(i);
                    i = i.subtract(BigInteger.ONE);
                }
                return NodeValue.makeInteger(res);
            }
        }
        throw new ExprEvalException("Unexpecte comparison result");
    }
}

