/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;

public abstract class FunctionBase
implements Function {
    @Override
    public final void build(String uri, ExprList args) {
        this.checkBuild(uri, args);
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        if (args == null) {
            throw new ARQInternalErrorException("FunctionBase: Null args list");
        }
        List<NodeValue> evalArgs = FunctionBase.evalArgs(binding, args, env);
        return this.exec(evalArgs, env);
    }

    public static List<NodeValue> evalArgs(Binding binding, ExprList args, FunctionEnv env) {
        ArrayList<NodeValue> evalArgs = new ArrayList<NodeValue>();
        for (Expr e2 : args) {
            NodeValue x = e2.eval(binding, env);
            evalArgs.add(x);
        }
        return evalArgs;
    }

    protected NodeValue exec(List<NodeValue> args, FunctionEnv env) {
        return this.exec(args);
    }

    public abstract NodeValue exec(List<NodeValue> var1);

    public abstract void checkBuild(String var1, ExprList var2);
}

