/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.describe;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.describe.DescribeHandler;
import org.apache.jena.sparql.util.Closure;
import org.apache.jena.sparql.util.Context;

public class DescribeBNodeClosure
implements DescribeHandler {
    Model acc;
    Dataset dataset;
    private static Query query = QueryFactory.create("SELECT DISTINCT ?g { GRAPH ?g { ?s ?p ?o } }");

    @Override
    public void start(Model accumulateResultModel, Context cxt) {
        this.acc = accumulateResultModel;
        this.dataset = (Dataset)cxt.get(ARQConstants.sysCurrentDataset);
    }

    @Override
    public void describe(Resource r) {
        Closure.closure(DescribeBNodeClosure.otherModel(r, this.dataset.getDefaultModel()), false, this.acc);
        QuerySolutionMap qsm = new QuerySolutionMap();
        qsm.add("s", r);
        try (QueryExecution qExec = QueryExecutionFactory.create(query, this.dataset, (QuerySolution)qsm);){
            ResultSet rs = qExec.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                String gName = qs.getResource("g").getURI();
                Model model = this.dataset.getNamedModel(gName);
                Resource r2 = DescribeBNodeClosure.otherModel(r, model);
                Closure.closure(r2, false, this.acc);
            }
        }
        Closure.closure(r, false, this.acc);
    }

    private static Resource otherModel(Resource r, Model model) {
        if (r.isURIResource()) {
            return model.createResource(r.getURI());
        }
        if (r.isAnon()) {
            return model.createResource(r.getId());
        }
        return r;
    }

    @Override
    public void finish() {
    }
}

