/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.AssemblerHelp;
import org.apache.jena.assembler.JA;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntologyException;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.ProfileRegistry;
import org.apache.jena.ontology.impl.OntModelImpl;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelGetter;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import org.apache.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import org.apache.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import org.apache.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import org.apache.jena.shared.JenaException;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class OntModelSpec {
    public static final OntModelSpec OWL_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_MICRO_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLMicroReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_MINI_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLMiniReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_DL_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.OWL_DL_LANG);
    public static final OntModelSpec OWL_DL_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_DL_LANG);
    public static final OntModelSpec OWL_DL_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.OWL_DL_LANG);
    public static final OntModelSpec OWL_DL_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_DL_LANG);
    public static final OntModelSpec OWL_LITE_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.OWL_LITE_LANG);
    public static final OntModelSpec OWL_LITE_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.OWL_LITE_LANG);
    public static final OntModelSpec OWL_LITE_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LITE_LANG);
    public static final OntModelSpec OWL_LITE_MEM_RULES_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LITE_LANG);
    public static final OntModelSpec RDFS_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.RDFS_LANG);
    public static final OntModelSpec RDFS_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.RDFS_LANG);
    public static final OntModelSpec RDFS_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.RDFS_LANG);
    protected OntDocumentManager m_docManager = null;
    protected Reasoner m_reasoner = null;
    protected String m_languageURI;
    protected Profile m_profile = null;
    protected ReasonerFactory m_rFactory = null;
    protected ModelMaker m_importsMaker;
    protected String m_baseModelName;
    protected ModelGetter importModelGetter;
    protected String[][] defaultPrefixes = new String[][]{{"owl", OWL.getURI()}, {"rdf", RDF.getURI()}, {"rdfs", RDFS.getURI()}, {"xsd", XSD.getURI()}};
    protected ModelMaker maker;

    public OntModelSpec(ModelMaker importsMaker, OntDocumentManager docMgr, ReasonerFactory rFactory, String languageURI) {
        this(ModelFactory.createMemModelMaker(), importsMaker, docMgr, rFactory, languageURI);
    }

    public OntModelSpec(ModelMaker baseMaker, ModelMaker importsMaker, OntDocumentManager docMgr, ReasonerFactory rFactory, String languageURI) {
        this(null, baseMaker, importsMaker, docMgr, rFactory, languageURI);
    }

    public OntModelSpec(String baseModelName, ModelMaker baseMaker, ModelMaker importsMaker, OntDocumentManager docMgr, ReasonerFactory rFactory, String languageURI) {
        this.maker = baseMaker;
        this.m_baseModelName = baseModelName;
        this.m_importsMaker = importsMaker == null ? ModelFactory.createMemModelMaker() : importsMaker;
        this.setDocumentManager(docMgr);
        this.setReasonerFactory(rFactory);
        if (languageURI == null) {
            throw new IllegalArgumentException("Cannot create OntModelSpec with a null ontology language");
        }
        this.setLanguage(languageURI);
    }

    public OntModelSpec(OntModelSpec spec) {
        this(spec.getBaseModelMaker(), spec.getImportModelMaker(), spec.getDocumentManager(), spec.getReasonerFactory(), spec.getLanguage());
    }

    public boolean equals(Object other) {
        return other instanceof OntModelSpec && this.same((OntModelSpec)other);
    }

    private boolean same(OntModelSpec other) {
        return this.getLanguage().equals(other.getLanguage()) && this.sameReasonerFactory(other) && this.getDocumentManager().equals(other.getDocumentManager()) && this.getImportModelGetter().equals(other.getImportModelGetter());
    }

    private boolean sameReasonerFactory(OntModelSpec other) {
        ReasonerFactory rf = this.getReasonerFactory();
        ReasonerFactory orf = other.getReasonerFactory();
        return rf == null ? orf == null : rf.equals(orf);
    }

    public ModelMaker getImportModelMaker() {
        return this.m_importsMaker;
    }

    public ModelMaker getBaseModelMaker() {
        return this.maker;
    }

    public ModelGetter getImportModelGetter() {
        if (this.importModelGetter == null) {
            this.importModelGetter = this.m_importsMaker;
        }
        return this.importModelGetter;
    }

    public void setImportModelGetter(ModelGetter mg) {
        this.importModelGetter = mg;
    }

    public static OntModelSpec assemble(Resource root2) {
        Object assembled = Assembler.general.open(root2);
        if (!(assembled instanceof OntModelSpec)) {
            throw new JenaException("assemble: expected an OntModelSpec, but got a " + assembled.getClass().getName());
        }
        return (OntModelSpec)assembled;
    }

    public static OntModelSpec assemble(Model model) {
        return OntModelSpec.assemble(AssemblerHelp.singleRoot(model, JA.OntModelSpec));
    }

    public static OntModelSpec getDefaultSpec(String languageURI) {
        if (languageURI.equals(ProfileRegistry.OWL_LANG)) {
            return OWL_MEM_RDFS_INF;
        }
        if (languageURI.equals(ProfileRegistry.OWL_DL_LANG)) {
            return OWL_DL_MEM_RDFS_INF;
        }
        if (languageURI.equals(ProfileRegistry.OWL_LITE_LANG)) {
            return OWL_LITE_MEM_RDFS_INF;
        }
        if (languageURI.equals(ProfileRegistry.RDFS_LANG)) {
            return RDFS_MEM_RDFS_INF;
        }
        throw new OntologyException("Did not recognise this language URI, so cannot determine default model spec: " + languageURI);
    }

    public OntDocumentManager getDocumentManager() {
        if (this.m_docManager == null) {
            this.m_docManager = OntDocumentManager.getInstance();
        }
        return this.m_docManager;
    }

    public void setDocumentManager(OntDocumentManager docMgr) {
        this.m_docManager = docMgr;
    }

    public void setImportModelMaker(ModelMaker maker) {
        this.m_importsMaker = maker;
    }

    public void setBaseModelMaker(ModelMaker m) {
        this.maker = m;
    }

    public Reasoner getReasoner() {
        if (this.m_reasoner == null && this.m_rFactory != null) {
            return this.m_rFactory.create(null);
        }
        return this.m_reasoner;
    }

    public void setReasoner(Reasoner reasoner) {
        this.m_reasoner = reasoner;
    }

    public void setReasonerFactory(ReasonerFactory rFactory) {
        this.m_rFactory = rFactory;
    }

    public ReasonerFactory getReasonerFactory() {
        return this.m_rFactory;
    }

    public String getLanguage() {
        return this.m_languageURI;
    }

    public void setLanguage(String languageURI) {
        this.m_languageURI = languageURI;
        this.m_profile = ProfileRegistry.getInstance().getProfile(this.m_languageURI);
        if (this.m_profile == null) {
            throw new OntologyException("Could not determine an ontology language profile for URI " + this.m_languageURI);
        }
    }

    public Profile getProfile() {
        return this.m_profile;
    }

    public Model doCreateModel() {
        Model m = this.m_baseModelName == null ? this.maker.createFreshModel() : this.maker.createModel(this.m_baseModelName);
        return new OntModelImpl(this, m);
    }

    public Model implementCreateModelOver(String name) {
        return new OntModelImpl(this, this.maker.createModel(name, false));
    }

    public Model createBaseModel() {
        return ModelFactory.createDefaultModel();
    }

    public String[][] getKnownPrefixes() {
        return this.defaultPrefixes;
    }
}

